package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.RenderingEngineVersionType
import scala.jdk.CollectionConverters._
final case class RenderingEngine(
    name: Option[zio.aws.robomaker.model.RenderingEngineType] = None,
    version: Option[RenderingEngineVersionType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.RenderingEngine = {
    import RenderingEngine.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.RenderingEngine
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        version.map(value =>
          RenderingEngineVersionType.unwrap(value): java.lang.String
        )
      )(_.version)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.RenderingEngine.ReadOnly =
    zio.aws.robomaker.model.RenderingEngine.wrap(buildAwsValue())
}
object RenderingEngine {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.RenderingEngine
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.RenderingEngine =
      zio.aws.robomaker.model
        .RenderingEngine(name.map(value => value), version.map(value => value))
    def name: Option[zio.aws.robomaker.model.RenderingEngineType]
    def version: Option[RenderingEngineVersionType]
    def getName
        : ZIO[Any, AwsError, zio.aws.robomaker.model.RenderingEngineType] =
      AwsError.unwrapOptionField("name", name)
    def getVersion: ZIO[Any, AwsError, RenderingEngineVersionType] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.RenderingEngine
  ) extends zio.aws.robomaker.model.RenderingEngine.ReadOnly {
    override val name: Option[zio.aws.robomaker.model.RenderingEngineType] =
      scala
        .Option(impl.name())
        .map(value => zio.aws.robomaker.model.RenderingEngineType.wrap(value))
    override val version: Option[RenderingEngineVersionType] = scala
      .Option(impl.version())
      .map(value =>
        zio.aws.robomaker.model.primitives.RenderingEngineVersionType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.RenderingEngine
  ): zio.aws.robomaker.model.RenderingEngine.ReadOnly = new Wrapper(impl)
}
