package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.robomaker.model.primitives.{CreatedAt, Id, Name, Arn}
import scala.jdk.CollectionConverters._
final case class Robot(
    arn: Option[Arn] = None,
    name: Option[Name] = None,
    fleetArn: Option[Arn] = None,
    status: Option[zio.aws.robomaker.model.RobotStatus] = None,
    greenGrassGroupId: Option[Id] = None,
    createdAt: Option[CreatedAt] = None,
    architecture: Option[zio.aws.robomaker.model.Architecture] = None,
    lastDeploymentJob: Option[Arn] = None,
    lastDeploymentTime: Option[CreatedAt] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.robomaker.model.Robot = {
    import Robot.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.Robot
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        fleetArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.fleetArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        greenGrassGroupId.map(value => Id.unwrap(value): java.lang.String)
      )(_.greenGrassGroupId)
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(architecture.map(value => value.unwrap))(_.architecture)
      .optionallyWith(
        lastDeploymentJob.map(value => Arn.unwrap(value): java.lang.String)
      )(_.lastDeploymentJob)
      .optionallyWith(
        lastDeploymentTime.map(value => CreatedAt.unwrap(value): Instant)
      )(_.lastDeploymentTime)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.Robot.ReadOnly =
    zio.aws.robomaker.model.Robot.wrap(buildAwsValue())
}
object Robot {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.robomaker.model.Robot] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.Robot =
      zio.aws.robomaker.model.Robot(
        arn.map(value => value),
        name.map(value => value),
        fleetArn.map(value => value),
        status.map(value => value),
        greenGrassGroupId.map(value => value),
        createdAt.map(value => value),
        architecture.map(value => value),
        lastDeploymentJob.map(value => value),
        lastDeploymentTime.map(value => value)
      )
    def arn: Option[Arn]
    def name: Option[Name]
    def fleetArn: Option[Arn]
    def status: Option[zio.aws.robomaker.model.RobotStatus]
    def greenGrassGroupId: Option[Id]
    def createdAt: Option[CreatedAt]
    def architecture: Option[zio.aws.robomaker.model.Architecture]
    def lastDeploymentJob: Option[Arn]
    def lastDeploymentTime: Option[CreatedAt]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getFleetArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("fleetArn", fleetArn)
    def getStatus: ZIO[Any, AwsError, zio.aws.robomaker.model.RobotStatus] =
      AwsError.unwrapOptionField("status", status)
    def getGreenGrassGroupId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("greenGrassGroupId", greenGrassGroupId)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getArchitecture
        : ZIO[Any, AwsError, zio.aws.robomaker.model.Architecture] =
      AwsError.unwrapOptionField("architecture", architecture)
    def getLastDeploymentJob: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("lastDeploymentJob", lastDeploymentJob)
    def getLastDeploymentTime: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("lastDeploymentTime", lastDeploymentTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.Robot
  ) extends zio.aws.robomaker.model.Robot.ReadOnly {
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.robomaker.model.primitives.Name(value))
    override val fleetArn: Option[Arn] = scala
      .Option(impl.fleetArn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val status: Option[zio.aws.robomaker.model.RobotStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.robomaker.model.RobotStatus.wrap(value))
    override val greenGrassGroupId: Option[Id] = scala
      .Option(impl.greenGrassGroupId())
      .map(value => zio.aws.robomaker.model.primitives.Id(value))
    override val createdAt: Option[CreatedAt] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.robomaker.model.primitives.CreatedAt(value))
    override val architecture: Option[zio.aws.robomaker.model.Architecture] =
      scala
        .Option(impl.architecture())
        .map(value => zio.aws.robomaker.model.Architecture.wrap(value))
    override val lastDeploymentJob: Option[Arn] = scala
      .Option(impl.lastDeploymentJob())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val lastDeploymentTime: Option[CreatedAt] = scala
      .Option(impl.lastDeploymentTime())
      .map(value => zio.aws.robomaker.model.primitives.CreatedAt(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.Robot
  ): zio.aws.robomaker.model.Robot.ReadOnly = new Wrapper(impl)
}
