package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.robomaker.model.primitives.{Name, LastUpdatedAt, Arn}
import scala.jdk.CollectionConverters._
final case class SimulationJobSummary(
    arn: Option[Arn] = None,
    lastUpdatedAt: Option[LastUpdatedAt] = None,
    name: Option[Name] = None,
    status: Option[zio.aws.robomaker.model.SimulationJobStatus] = None,
    simulationApplicationNames: Option[Iterable[Name]] = None,
    robotApplicationNames: Option[Iterable[Name]] = None,
    dataSourceNames: Option[Iterable[Name]] = None,
    computeType: Option[zio.aws.robomaker.model.ComputeType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.SimulationJobSummary = {
    import SimulationJobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.SimulationJobSummary
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        lastUpdatedAt.map(value => LastUpdatedAt.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        simulationApplicationNames.map(value =>
          value.map { item =>
            Name.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.simulationApplicationNames)
      .optionallyWith(
        robotApplicationNames.map(value =>
          value.map { item =>
            Name.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.robotApplicationNames)
      .optionallyWith(
        dataSourceNames.map(value =>
          value.map { item =>
            Name.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dataSourceNames)
      .optionallyWith(computeType.map(value => value.unwrap))(_.computeType)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.SimulationJobSummary.ReadOnly =
    zio.aws.robomaker.model.SimulationJobSummary.wrap(buildAwsValue())
}
object SimulationJobSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.SimulationJobSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.SimulationJobSummary =
      zio.aws.robomaker.model.SimulationJobSummary(
        arn.map(value => value),
        lastUpdatedAt.map(value => value),
        name.map(value => value),
        status.map(value => value),
        simulationApplicationNames.map(value => value),
        robotApplicationNames.map(value => value),
        dataSourceNames.map(value => value),
        computeType.map(value => value)
      )
    def arn: Option[Arn]
    def lastUpdatedAt: Option[LastUpdatedAt]
    def name: Option[Name]
    def status: Option[zio.aws.robomaker.model.SimulationJobStatus]
    def simulationApplicationNames: Option[List[Name]]
    def robotApplicationNames: Option[List[Name]]
    def dataSourceNames: Option[List[Name]]
    def computeType: Option[zio.aws.robomaker.model.ComputeType]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getLastUpdatedAt: ZIO[Any, AwsError, LastUpdatedAt] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.robomaker.model.SimulationJobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSimulationApplicationNames: ZIO[Any, AwsError, List[Name]] =
      AwsError.unwrapOptionField(
        "simulationApplicationNames",
        simulationApplicationNames
      )
    def getRobotApplicationNames: ZIO[Any, AwsError, List[Name]] =
      AwsError.unwrapOptionField("robotApplicationNames", robotApplicationNames)
    def getDataSourceNames: ZIO[Any, AwsError, List[Name]] =
      AwsError.unwrapOptionField("dataSourceNames", dataSourceNames)
    def getComputeType
        : ZIO[Any, AwsError, zio.aws.robomaker.model.ComputeType] =
      AwsError.unwrapOptionField("computeType", computeType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.SimulationJobSummary
  ) extends zio.aws.robomaker.model.SimulationJobSummary.ReadOnly {
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val lastUpdatedAt: Option[LastUpdatedAt] = scala
      .Option(impl.lastUpdatedAt())
      .map(value => zio.aws.robomaker.model.primitives.LastUpdatedAt(value))
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.robomaker.model.primitives.Name(value))
    override val status: Option[zio.aws.robomaker.model.SimulationJobStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.robomaker.model.SimulationJobStatus.wrap(value))
    override val simulationApplicationNames: Option[List[Name]] = scala
      .Option(impl.simulationApplicationNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.primitives.Name(item)
        }.toList
      )
    override val robotApplicationNames: Option[List[Name]] = scala
      .Option(impl.robotApplicationNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.primitives.Name(item)
        }.toList
      )
    override val dataSourceNames: Option[List[Name]] = scala
      .Option(impl.dataSourceNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.primitives.Name(item)
        }.toList
      )
    override val computeType: Option[zio.aws.robomaker.model.ComputeType] =
      scala
        .Option(impl.computeType())
        .map(value => zio.aws.robomaker.model.ComputeType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.SimulationJobSummary
  ): zio.aws.robomaker.model.SimulationJobSummary.ReadOnly = new Wrapper(impl)
}
