package zio.aws.robomaker.model
import scala.jdk.CollectionConverters._
sealed trait SimulationSoftwareSuiteType {
  def unwrap: software.amazon.awssdk.services.robomaker.model.SimulationSoftwareSuiteType
}
object SimulationSoftwareSuiteType {
  def wrap(
      value: software.amazon.awssdk.services.robomaker.model.SimulationSoftwareSuiteType
  ): zio.aws.robomaker.model.SimulationSoftwareSuiteType = value match {
    case software.amazon.awssdk.services.robomaker.model.SimulationSoftwareSuiteType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationSoftwareSuiteType.GAZEBO =>
      val r = Gazebo
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationSoftwareSuiteType.ROSBAG_PLAY =>
      val r = RosbagPlay
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationSoftwareSuiteType.SIMULATION_RUNTIME =>
      val r = SimulationRuntime
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.robomaker.model.SimulationSoftwareSuiteType {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationSoftwareSuiteType =
      software.amazon.awssdk.services.robomaker.model.SimulationSoftwareSuiteType.UNKNOWN_TO_SDK_VERSION
  }
  case object Gazebo
      extends zio.aws.robomaker.model.SimulationSoftwareSuiteType {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationSoftwareSuiteType =
      software.amazon.awssdk.services.robomaker.model.SimulationSoftwareSuiteType.GAZEBO
  }
  case object RosbagPlay
      extends zio.aws.robomaker.model.SimulationSoftwareSuiteType {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationSoftwareSuiteType =
      software.amazon.awssdk.services.robomaker.model.SimulationSoftwareSuiteType.ROSBAG_PLAY
  }
  case object SimulationRuntime
      extends zio.aws.robomaker.model.SimulationSoftwareSuiteType {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationSoftwareSuiteType =
      software.amazon.awssdk.services.robomaker.model.SimulationSoftwareSuiteType.SIMULATION_RUNTIME
  }
}
