package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.{S3Key, S3Bucket}
import scala.jdk.CollectionConverters._
final case class SourceConfig(
    s3Bucket: Option[S3Bucket] = None,
    s3Key: Option[S3Key] = None,
    architecture: Option[zio.aws.robomaker.model.Architecture] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.SourceConfig = {
    import SourceConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.SourceConfig
      .builder()
      .optionallyWith(
        s3Bucket.map(value => S3Bucket.unwrap(value): java.lang.String)
      )(_.s3Bucket)
      .optionallyWith(
        s3Key.map(value => S3Key.unwrap(value): java.lang.String)
      )(_.s3Key)
      .optionallyWith(architecture.map(value => value.unwrap))(_.architecture)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.SourceConfig.ReadOnly =
    zio.aws.robomaker.model.SourceConfig.wrap(buildAwsValue())
}
object SourceConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.SourceConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.SourceConfig =
      zio.aws.robomaker.model.SourceConfig(
        s3Bucket.map(value => value),
        s3Key.map(value => value),
        architecture.map(value => value)
      )
    def s3Bucket: Option[S3Bucket]
    def s3Key: Option[S3Key]
    def architecture: Option[zio.aws.robomaker.model.Architecture]
    def getS3Bucket: ZIO[Any, AwsError, S3Bucket] =
      AwsError.unwrapOptionField("s3Bucket", s3Bucket)
    def getS3Key: ZIO[Any, AwsError, S3Key] =
      AwsError.unwrapOptionField("s3Key", s3Key)
    def getArchitecture
        : ZIO[Any, AwsError, zio.aws.robomaker.model.Architecture] =
      AwsError.unwrapOptionField("architecture", architecture)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.SourceConfig
  ) extends zio.aws.robomaker.model.SourceConfig.ReadOnly {
    override val s3Bucket: Option[S3Bucket] = scala
      .Option(impl.s3Bucket())
      .map(value => zio.aws.robomaker.model.primitives.S3Bucket(value))
    override val s3Key: Option[S3Key] = scala
      .Option(impl.s3Key())
      .map(value => zio.aws.robomaker.model.primitives.S3Key(value))
    override val architecture: Option[zio.aws.robomaker.model.Architecture] =
      scala
        .Option(impl.architecture())
        .map(value => zio.aws.robomaker.model.Architecture.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.SourceConfig
  ): zio.aws.robomaker.model.SourceConfig.ReadOnly = new Wrapper(impl)
}
