package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.robomaker.model.primitives.{
  RevisionId,
  Arn,
  Version,
  Name,
  LastUpdatedAt
}
import scala.jdk.CollectionConverters._
final case class UpdateSimulationApplicationResponse(
    arn: Option[Arn] = None,
    name: Option[Name] = None,
    version: Option[Version] = None,
    sources: Option[Iterable[zio.aws.robomaker.model.Source]] = None,
    simulationSoftwareSuite: Option[
      zio.aws.robomaker.model.SimulationSoftwareSuite
    ] = None,
    robotSoftwareSuite: Option[zio.aws.robomaker.model.RobotSoftwareSuite] =
      None,
    renderingEngine: Option[zio.aws.robomaker.model.RenderingEngine] = None,
    lastUpdatedAt: Option[LastUpdatedAt] = None,
    revisionId: Option[RevisionId] = None,
    environment: Option[zio.aws.robomaker.model.Environment] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.UpdateSimulationApplicationResponse = {
    import UpdateSimulationApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.UpdateSimulationApplicationResponse
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        version.map(value => Version.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(
        sources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sources)
      .optionallyWith(
        simulationSoftwareSuite.map(value => value.buildAwsValue())
      )(_.simulationSoftwareSuite)
      .optionallyWith(robotSoftwareSuite.map(value => value.buildAwsValue()))(
        _.robotSoftwareSuite
      )
      .optionallyWith(renderingEngine.map(value => value.buildAwsValue()))(
        _.renderingEngine
      )
      .optionallyWith(
        lastUpdatedAt.map(value => LastUpdatedAt.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        revisionId.map(value => RevisionId.unwrap(value): java.lang.String)
      )(_.revisionId)
      .optionallyWith(environment.map(value => value.buildAwsValue()))(
        _.environment
      )
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.UpdateSimulationApplicationResponse.ReadOnly =
    zio.aws.robomaker.model.UpdateSimulationApplicationResponse
      .wrap(buildAwsValue())
}
object UpdateSimulationApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.UpdateSimulationApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.robomaker.model.UpdateSimulationApplicationResponse =
      zio.aws.robomaker.model.UpdateSimulationApplicationResponse(
        arn.map(value => value),
        name.map(value => value),
        version.map(value => value),
        sources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        simulationSoftwareSuite.map(value => value.asEditable),
        robotSoftwareSuite.map(value => value.asEditable),
        renderingEngine.map(value => value.asEditable),
        lastUpdatedAt.map(value => value),
        revisionId.map(value => value),
        environment.map(value => value.asEditable)
      )
    def arn: Option[Arn]
    def name: Option[Name]
    def version: Option[Version]
    def sources: Option[List[zio.aws.robomaker.model.Source.ReadOnly]]
    def simulationSoftwareSuite
        : Option[zio.aws.robomaker.model.SimulationSoftwareSuite.ReadOnly]
    def robotSoftwareSuite
        : Option[zio.aws.robomaker.model.RobotSoftwareSuite.ReadOnly]
    def renderingEngine
        : Option[zio.aws.robomaker.model.RenderingEngine.ReadOnly]
    def lastUpdatedAt: Option[LastUpdatedAt]
    def revisionId: Option[RevisionId]
    def environment: Option[zio.aws.robomaker.model.Environment.ReadOnly]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("version", version)
    def getSources
        : ZIO[Any, AwsError, List[zio.aws.robomaker.model.Source.ReadOnly]] =
      AwsError.unwrapOptionField("sources", sources)
    def getSimulationSoftwareSuite: ZIO[
      Any,
      AwsError,
      zio.aws.robomaker.model.SimulationSoftwareSuite.ReadOnly
    ] = AwsError.unwrapOptionField(
      "simulationSoftwareSuite",
      simulationSoftwareSuite
    )
    def getRobotSoftwareSuite: ZIO[
      Any,
      AwsError,
      zio.aws.robomaker.model.RobotSoftwareSuite.ReadOnly
    ] = AwsError.unwrapOptionField("robotSoftwareSuite", robotSoftwareSuite)
    def getRenderingEngine
        : ZIO[Any, AwsError, zio.aws.robomaker.model.RenderingEngine.ReadOnly] =
      AwsError.unwrapOptionField("renderingEngine", renderingEngine)
    def getLastUpdatedAt: ZIO[Any, AwsError, LastUpdatedAt] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getRevisionId: ZIO[Any, AwsError, RevisionId] =
      AwsError.unwrapOptionField("revisionId", revisionId)
    def getEnvironment
        : ZIO[Any, AwsError, zio.aws.robomaker.model.Environment.ReadOnly] =
      AwsError.unwrapOptionField("environment", environment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.UpdateSimulationApplicationResponse
  ) extends zio.aws.robomaker.model.UpdateSimulationApplicationResponse.ReadOnly {
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.robomaker.model.primitives.Name(value))
    override val version: Option[Version] = scala
      .Option(impl.version())
      .map(value => zio.aws.robomaker.model.primitives.Version(value))
    override val sources
        : Option[List[zio.aws.robomaker.model.Source.ReadOnly]] = scala
      .Option(impl.sources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.Source.wrap(item)
        }.toList
      )
    override val simulationSoftwareSuite
        : Option[zio.aws.robomaker.model.SimulationSoftwareSuite.ReadOnly] =
      scala
        .Option(impl.simulationSoftwareSuite())
        .map(value =>
          zio.aws.robomaker.model.SimulationSoftwareSuite.wrap(value)
        )
    override val robotSoftwareSuite
        : Option[zio.aws.robomaker.model.RobotSoftwareSuite.ReadOnly] = scala
      .Option(impl.robotSoftwareSuite())
      .map(value => zio.aws.robomaker.model.RobotSoftwareSuite.wrap(value))
    override val renderingEngine
        : Option[zio.aws.robomaker.model.RenderingEngine.ReadOnly] = scala
      .Option(impl.renderingEngine())
      .map(value => zio.aws.robomaker.model.RenderingEngine.wrap(value))
    override val lastUpdatedAt: Option[LastUpdatedAt] = scala
      .Option(impl.lastUpdatedAt())
      .map(value => zio.aws.robomaker.model.primitives.LastUpdatedAt(value))
    override val revisionId: Option[RevisionId] = scala
      .Option(impl.revisionId())
      .map(value => zio.aws.robomaker.model.primitives.RevisionId(value))
    override val environment
        : Option[zio.aws.robomaker.model.Environment.ReadOnly] = scala
      .Option(impl.environment())
      .map(value => zio.aws.robomaker.model.Environment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.UpdateSimulationApplicationResponse
  ): zio.aws.robomaker.model.UpdateSimulationApplicationResponse.ReadOnly =
    new Wrapper(impl)
}
