package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class VPCConfig(
    subnets: Iterable[NonEmptyString],
    securityGroups: Option[Iterable[NonEmptyString]] = None,
    assignPublicIp: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.VPCConfig = {
    import VPCConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.VPCConfig
      .builder()
      .subnets(subnets.map { item =>
        NonEmptyString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(assignPublicIp.map(value => value: java.lang.Boolean))(
        _.assignPublicIp
      )
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.VPCConfig.ReadOnly =
    zio.aws.robomaker.model.VPCConfig.wrap(buildAwsValue())
}
object VPCConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.VPCConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.VPCConfig =
      zio.aws.robomaker.model.VPCConfig(
        subnets,
        securityGroups.map(value => value),
        assignPublicIp.map(value => value)
      )
    def subnets: List[NonEmptyString]
    def securityGroups: Option[List[NonEmptyString]]
    def assignPublicIp: Option[Boolean]
    def getSubnets: ZIO[Any, Nothing, List[NonEmptyString]] =
      ZIO.succeed(subnets)
    def getSecurityGroups: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getAssignPublicIp: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("assignPublicIp", assignPublicIp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.VPCConfig
  ) extends zio.aws.robomaker.model.VPCConfig.ReadOnly {
    override val subnets: List[NonEmptyString] = impl
      .subnets()
      .asScala
      .map { item =>
        zio.aws.robomaker.model.primitives.NonEmptyString(item)
      }
      .toList
    override val securityGroups: Option[List[NonEmptyString]] = scala
      .Option(impl.securityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val assignPublicIp: Option[Boolean] =
      scala.Option(impl.assignPublicIp()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.VPCConfig
  ): zio.aws.robomaker.model.VPCConfig.ReadOnly = new Wrapper(impl)
}
