package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class WorldConfig(world: Option[Arn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.WorldConfig = {
    import WorldConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.WorldConfig
      .builder()
      .optionallyWith(world.map(value => Arn.unwrap(value): java.lang.String))(
        _.world
      )
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.WorldConfig.ReadOnly =
    zio.aws.robomaker.model.WorldConfig.wrap(buildAwsValue())
}
object WorldConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.WorldConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.WorldConfig =
      zio.aws.robomaker.model.WorldConfig(world.map(value => value))
    def world: Option[Arn]
    def getWorld: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("world", world)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.WorldConfig
  ) extends zio.aws.robomaker.model.WorldConfig.ReadOnly {
    override val world: Option[Arn] = scala
      .Option(impl.world())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.WorldConfig
  ): zio.aws.robomaker.model.WorldConfig.ReadOnly = new Wrapper(impl)
}
