package zio.aws.robomaker
import zio.aws.robomaker.model.TagResourceResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.robomaker.RoboMakerAsyncClient
import zio.aws.robomaker.model.{
  ListWorldExportJobsRequest,
  UpdateWorldTemplateRequest,
  CreateRobotApplicationRequest,
  ListWorldTemplatesRequest,
  BatchDeleteWorldsRequest,
  DescribeSimulationJobBatchRequest,
  CreateWorldExportJobRequest,
  UpdateSimulationApplicationRequest,
  DescribeSimulationApplicationRequest,
  ListRobotApplicationsRequest,
  CancelSimulationJobBatchRequest,
  UpdateRobotApplicationRequest,
  ListTagsForResourceRequest,
  CreateSimulationApplicationRequest,
  CreateSimulationApplicationVersionRequest,
  DeleteWorldTemplateRequest,
  CreateWorldGenerationJobRequest,
  DescribeWorldTemplateRequest,
  RestartSimulationJobRequest,
  DescribeWorldGenerationJobRequest,
  CancelWorldExportJobRequest,
  DescribeSimulationJobRequest,
  ListSimulationJobsRequest,
  CreateWorldTemplateRequest,
  GetWorldTemplateBodyRequest,
  CancelSimulationJobRequest,
  UntagResourceRequest,
  CreateRobotApplicationVersionRequest,
  BatchDescribeSimulationJobRequest,
  DescribeWorldRequest,
  ListWorldGenerationJobsRequest,
  ListSimulationJobBatchesRequest,
  ListWorldsRequest,
  DescribeWorldExportJobRequest,
  DeleteSimulationApplicationRequest,
  ListSimulationApplicationsRequest,
  DeleteRobotApplicationRequest,
  DescribeRobotApplicationRequest,
  StartSimulationJobBatchRequest,
  CancelWorldGenerationJobRequest,
  TagResourceRequest,
  CreateSimulationJobRequest
}
import zio.stream.ZStream
object RoboMakerMock extends Mock[RoboMaker] {
  object DescribeSimulationJob
      extends Effect[
        DescribeSimulationJobRequest,
        AwsError,
        zio.aws.robomaker.model.DescribeSimulationJobResponse.ReadOnly
      ]
  object UpdateWorldTemplate
      extends Effect[
        UpdateWorldTemplateRequest,
        AwsError,
        zio.aws.robomaker.model.UpdateWorldTemplateResponse.ReadOnly
      ]
  object DescribeWorldGenerationJob
      extends Effect[
        DescribeWorldGenerationJobRequest,
        AwsError,
        zio.aws.robomaker.model.DescribeWorldGenerationJobResponse.ReadOnly
      ]
  object DescribeWorldExportJob
      extends Effect[
        DescribeWorldExportJobRequest,
        AwsError,
        zio.aws.robomaker.model.DescribeWorldExportJobResponse.ReadOnly
      ]
  object CreateSimulationJob
      extends Effect[
        CreateSimulationJobRequest,
        AwsError,
        zio.aws.robomaker.model.CreateSimulationJobResponse.ReadOnly
      ]
  object CancelWorldExportJob
      extends Effect[
        CancelWorldExportJobRequest,
        AwsError,
        zio.aws.robomaker.model.CancelWorldExportJobResponse.ReadOnly
      ]
  object ListSimulationJobBatches
      extends Stream[
        ListSimulationJobBatchesRequest,
        AwsError,
        zio.aws.robomaker.model.SimulationJobBatchSummary.ReadOnly
      ]
  object ListSimulationJobBatchesPaginated
      extends Effect[
        ListSimulationJobBatchesRequest,
        AwsError,
        zio.aws.robomaker.model.ListSimulationJobBatchesResponse.ReadOnly
      ]
  object ListRobotApplications
      extends Stream[
        ListRobotApplicationsRequest,
        AwsError,
        zio.aws.robomaker.model.RobotApplicationSummary.ReadOnly
      ]
  object ListRobotApplicationsPaginated
      extends Effect[
        ListRobotApplicationsRequest,
        AwsError,
        zio.aws.robomaker.model.ListRobotApplicationsResponse.ReadOnly
      ]
  object DescribeWorldTemplate
      extends Effect[
        DescribeWorldTemplateRequest,
        AwsError,
        zio.aws.robomaker.model.DescribeWorldTemplateResponse.ReadOnly
      ]
  object CreateWorldExportJob
      extends Effect[
        CreateWorldExportJobRequest,
        AwsError,
        zio.aws.robomaker.model.CreateWorldExportJobResponse.ReadOnly
      ]
  object CreateWorldTemplate
      extends Effect[
        CreateWorldTemplateRequest,
        AwsError,
        zio.aws.robomaker.model.CreateWorldTemplateResponse.ReadOnly
      ]
  object StartSimulationJobBatch
      extends Effect[
        StartSimulationJobBatchRequest,
        AwsError,
        zio.aws.robomaker.model.StartSimulationJobBatchResponse.ReadOnly
      ]
  object DescribeSimulationJobBatch
      extends Effect[
        DescribeSimulationJobBatchRequest,
        AwsError,
        zio.aws.robomaker.model.DescribeSimulationJobBatchResponse.ReadOnly
      ]
  object CreateRobotApplicationVersion
      extends Effect[
        CreateRobotApplicationVersionRequest,
        AwsError,
        zio.aws.robomaker.model.CreateRobotApplicationVersionResponse.ReadOnly
      ]
  object ListWorlds
      extends Stream[
        ListWorldsRequest,
        AwsError,
        zio.aws.robomaker.model.WorldSummary.ReadOnly
      ]
  object ListWorldsPaginated
      extends Effect[
        ListWorldsRequest,
        AwsError,
        zio.aws.robomaker.model.ListWorldsResponse.ReadOnly
      ]
  object RestartSimulationJob
      extends Effect[
        RestartSimulationJobRequest,
        AwsError,
        zio.aws.robomaker.model.RestartSimulationJobResponse.ReadOnly
      ]
  object ListSimulationJobs
      extends Stream[
        ListSimulationJobsRequest,
        AwsError,
        zio.aws.robomaker.model.SimulationJobSummary.ReadOnly
      ]
  object ListSimulationJobsPaginated
      extends Effect[
        ListSimulationJobsRequest,
        AwsError,
        zio.aws.robomaker.model.ListSimulationJobsResponse.ReadOnly
      ]
  object ListSimulationApplications
      extends Stream[
        ListSimulationApplicationsRequest,
        AwsError,
        zio.aws.robomaker.model.SimulationApplicationSummary.ReadOnly
      ]
  object ListSimulationApplicationsPaginated
      extends Effect[
        ListSimulationApplicationsRequest,
        AwsError,
        zio.aws.robomaker.model.ListSimulationApplicationsResponse.ReadOnly
      ]
  object DeleteWorldTemplate
      extends Effect[
        DeleteWorldTemplateRequest,
        AwsError,
        zio.aws.robomaker.model.DeleteWorldTemplateResponse.ReadOnly
      ]
  object BatchDescribeSimulationJob
      extends Effect[
        BatchDescribeSimulationJobRequest,
        AwsError,
        zio.aws.robomaker.model.BatchDescribeSimulationJobResponse.ReadOnly
      ]
  object CancelSimulationJob
      extends Effect[
        CancelSimulationJobRequest,
        AwsError,
        zio.aws.robomaker.model.CancelSimulationJobResponse.ReadOnly
      ]
  object CreateSimulationApplicationVersion
      extends Effect[
        CreateSimulationApplicationVersionRequest,
        AwsError,
        zio.aws.robomaker.model.CreateSimulationApplicationVersionResponse.ReadOnly
      ]
  object CreateRobotApplication
      extends Effect[
        CreateRobotApplicationRequest,
        AwsError,
        zio.aws.robomaker.model.CreateRobotApplicationResponse.ReadOnly
      ]
  object CreateWorldGenerationJob
      extends Effect[
        CreateWorldGenerationJobRequest,
        AwsError,
        zio.aws.robomaker.model.CreateWorldGenerationJobResponse.ReadOnly
      ]
  object CancelSimulationJobBatch
      extends Effect[
        CancelSimulationJobBatchRequest,
        AwsError,
        zio.aws.robomaker.model.CancelSimulationJobBatchResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.robomaker.model.UntagResourceResponse.ReadOnly
      ]
  object UpdateSimulationApplication
      extends Effect[
        UpdateSimulationApplicationRequest,
        AwsError,
        zio.aws.robomaker.model.UpdateSimulationApplicationResponse.ReadOnly
      ]
  object DescribeSimulationApplication
      extends Effect[
        DescribeSimulationApplicationRequest,
        AwsError,
        zio.aws.robomaker.model.DescribeSimulationApplicationResponse.ReadOnly
      ]
  object DeleteSimulationApplication
      extends Effect[
        DeleteSimulationApplicationRequest,
        AwsError,
        zio.aws.robomaker.model.DeleteSimulationApplicationResponse.ReadOnly
      ]
  object ListWorldTemplates
      extends Stream[
        ListWorldTemplatesRequest,
        AwsError,
        zio.aws.robomaker.model.TemplateSummary.ReadOnly
      ]
  object ListWorldTemplatesPaginated
      extends Effect[
        ListWorldTemplatesRequest,
        AwsError,
        zio.aws.robomaker.model.ListWorldTemplatesResponse.ReadOnly
      ]
  object GetWorldTemplateBody
      extends Effect[
        GetWorldTemplateBodyRequest,
        AwsError,
        zio.aws.robomaker.model.GetWorldTemplateBodyResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.robomaker.model.ListTagsForResourceResponse.ReadOnly
      ]
  object DescribeWorld
      extends Effect[
        DescribeWorldRequest,
        AwsError,
        zio.aws.robomaker.model.DescribeWorldResponse.ReadOnly
      ]
  object TagResource extends Effect[TagResourceRequest, AwsError, ReadOnly]
  object CreateSimulationApplication
      extends Effect[
        CreateSimulationApplicationRequest,
        AwsError,
        zio.aws.robomaker.model.CreateSimulationApplicationResponse.ReadOnly
      ]
  object CancelWorldGenerationJob
      extends Effect[
        CancelWorldGenerationJobRequest,
        AwsError,
        zio.aws.robomaker.model.CancelWorldGenerationJobResponse.ReadOnly
      ]
  object UpdateRobotApplication
      extends Effect[
        UpdateRobotApplicationRequest,
        AwsError,
        zio.aws.robomaker.model.UpdateRobotApplicationResponse.ReadOnly
      ]
  object DeleteRobotApplication
      extends Effect[
        DeleteRobotApplicationRequest,
        AwsError,
        zio.aws.robomaker.model.DeleteRobotApplicationResponse.ReadOnly
      ]
  object ListWorldExportJobs
      extends Stream[
        ListWorldExportJobsRequest,
        AwsError,
        zio.aws.robomaker.model.WorldExportJobSummary.ReadOnly
      ]
  object ListWorldExportJobsPaginated
      extends Effect[
        ListWorldExportJobsRequest,
        AwsError,
        zio.aws.robomaker.model.ListWorldExportJobsResponse.ReadOnly
      ]
  object DescribeRobotApplication
      extends Effect[
        DescribeRobotApplicationRequest,
        AwsError,
        zio.aws.robomaker.model.DescribeRobotApplicationResponse.ReadOnly
      ]
  object BatchDeleteWorlds
      extends Effect[
        BatchDeleteWorldsRequest,
        AwsError,
        zio.aws.robomaker.model.BatchDeleteWorldsResponse.ReadOnly
      ]
  object ListWorldGenerationJobs
      extends Stream[
        ListWorldGenerationJobsRequest,
        AwsError,
        zio.aws.robomaker.model.WorldGenerationJobSummary.ReadOnly
      ]
  object ListWorldGenerationJobsPaginated
      extends Effect[
        ListWorldGenerationJobsRequest,
        AwsError,
        zio.aws.robomaker.model.ListWorldGenerationJobsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, RoboMaker] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, RoboMaker] { rts =>
        zio.ZIO.succeed {
          new RoboMaker {
            val api: RoboMakerAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): RoboMaker = this
            def describeSimulationJob(
                request: DescribeSimulationJobRequest
            ): IO[
              AwsError,
              zio.aws.robomaker.model.DescribeSimulationJobResponse.ReadOnly
            ] = proxy(DescribeSimulationJob, request)
            def updateWorldTemplate(request: UpdateWorldTemplateRequest): IO[
              AwsError,
              zio.aws.robomaker.model.UpdateWorldTemplateResponse.ReadOnly
            ] = proxy(UpdateWorldTemplate, request)
            def describeWorldGenerationJob(
                request: DescribeWorldGenerationJobRequest
            ): IO[
              AwsError,
              zio.aws.robomaker.model.DescribeWorldGenerationJobResponse.ReadOnly
            ] = proxy(DescribeWorldGenerationJob, request)
            def describeWorldExportJob(
                request: DescribeWorldExportJobRequest
            ): IO[
              AwsError,
              zio.aws.robomaker.model.DescribeWorldExportJobResponse.ReadOnly
            ] = proxy(DescribeWorldExportJob, request)
            def createSimulationJob(request: CreateSimulationJobRequest): IO[
              AwsError,
              zio.aws.robomaker.model.CreateSimulationJobResponse.ReadOnly
            ] = proxy(CreateSimulationJob, request)
            def cancelWorldExportJob(request: CancelWorldExportJobRequest): IO[
              AwsError,
              zio.aws.robomaker.model.CancelWorldExportJobResponse.ReadOnly
            ] = proxy(CancelWorldExportJob, request)
            def listSimulationJobBatches(
                request: ListSimulationJobBatchesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.robomaker.model.SimulationJobBatchSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSimulationJobBatches, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSimulationJobBatchesPaginated(
                request: ListSimulationJobBatchesRequest
            ): IO[
              AwsError,
              zio.aws.robomaker.model.ListSimulationJobBatchesResponse.ReadOnly
            ] = proxy(ListSimulationJobBatchesPaginated, request)
            def listRobotApplications(
                request: ListRobotApplicationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.robomaker.model.RobotApplicationSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListRobotApplications, request)
                }
                .getOrThrowFiberFailure()
            }
            def listRobotApplicationsPaginated(
                request: ListRobotApplicationsRequest
            ): IO[
              AwsError,
              zio.aws.robomaker.model.ListRobotApplicationsResponse.ReadOnly
            ] = proxy(ListRobotApplicationsPaginated, request)
            def describeWorldTemplate(
                request: DescribeWorldTemplateRequest
            ): IO[
              AwsError,
              zio.aws.robomaker.model.DescribeWorldTemplateResponse.ReadOnly
            ] = proxy(DescribeWorldTemplate, request)
            def createWorldExportJob(request: CreateWorldExportJobRequest): IO[
              AwsError,
              zio.aws.robomaker.model.CreateWorldExportJobResponse.ReadOnly
            ] = proxy(CreateWorldExportJob, request)
            def createWorldTemplate(request: CreateWorldTemplateRequest): IO[
              AwsError,
              zio.aws.robomaker.model.CreateWorldTemplateResponse.ReadOnly
            ] = proxy(CreateWorldTemplate, request)
            def startSimulationJobBatch(
                request: StartSimulationJobBatchRequest
            ): IO[
              AwsError,
              zio.aws.robomaker.model.StartSimulationJobBatchResponse.ReadOnly
            ] = proxy(StartSimulationJobBatch, request)
            def describeSimulationJobBatch(
                request: DescribeSimulationJobBatchRequest
            ): IO[
              AwsError,
              zio.aws.robomaker.model.DescribeSimulationJobBatchResponse.ReadOnly
            ] = proxy(DescribeSimulationJobBatch, request)
            def createRobotApplicationVersion(
                request: CreateRobotApplicationVersionRequest
            ): IO[
              AwsError,
              zio.aws.robomaker.model.CreateRobotApplicationVersionResponse.ReadOnly
            ] = proxy(CreateRobotApplicationVersion, request)
            def listWorlds(request: ListWorldsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.robomaker.model.WorldSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListWorlds, request)
                }
                .getOrThrowFiberFailure()
            }
            def listWorldsPaginated(request: ListWorldsRequest): IO[
              AwsError,
              zio.aws.robomaker.model.ListWorldsResponse.ReadOnly
            ] = proxy(ListWorldsPaginated, request)
            def restartSimulationJob(request: RestartSimulationJobRequest): IO[
              AwsError,
              zio.aws.robomaker.model.RestartSimulationJobResponse.ReadOnly
            ] = proxy(RestartSimulationJob, request)
            def listSimulationJobs(request: ListSimulationJobsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.robomaker.model.SimulationJobSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSimulationJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSimulationJobsPaginated(
                request: ListSimulationJobsRequest
            ): IO[
              AwsError,
              zio.aws.robomaker.model.ListSimulationJobsResponse.ReadOnly
            ] = proxy(ListSimulationJobsPaginated, request)
            def listSimulationApplications(
                request: ListSimulationApplicationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.robomaker.model.SimulationApplicationSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSimulationApplications, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSimulationApplicationsPaginated(
                request: ListSimulationApplicationsRequest
            ): IO[
              AwsError,
              zio.aws.robomaker.model.ListSimulationApplicationsResponse.ReadOnly
            ] = proxy(ListSimulationApplicationsPaginated, request)
            def deleteWorldTemplate(request: DeleteWorldTemplateRequest): IO[
              AwsError,
              zio.aws.robomaker.model.DeleteWorldTemplateResponse.ReadOnly
            ] = proxy(DeleteWorldTemplate, request)
            def batchDescribeSimulationJob(
                request: BatchDescribeSimulationJobRequest
            ): IO[
              AwsError,
              zio.aws.robomaker.model.BatchDescribeSimulationJobResponse.ReadOnly
            ] = proxy(BatchDescribeSimulationJob, request)
            def cancelSimulationJob(request: CancelSimulationJobRequest): IO[
              AwsError,
              zio.aws.robomaker.model.CancelSimulationJobResponse.ReadOnly
            ] = proxy(CancelSimulationJob, request)
            def createSimulationApplicationVersion(
                request: CreateSimulationApplicationVersionRequest
            ): IO[
              AwsError,
              zio.aws.robomaker.model.CreateSimulationApplicationVersionResponse.ReadOnly
            ] = proxy(CreateSimulationApplicationVersion, request)
            def createRobotApplication(
                request: CreateRobotApplicationRequest
            ): IO[
              AwsError,
              zio.aws.robomaker.model.CreateRobotApplicationResponse.ReadOnly
            ] = proxy(CreateRobotApplication, request)
            def createWorldGenerationJob(
                request: CreateWorldGenerationJobRequest
            ): IO[
              AwsError,
              zio.aws.robomaker.model.CreateWorldGenerationJobResponse.ReadOnly
            ] = proxy(CreateWorldGenerationJob, request)
            def cancelSimulationJobBatch(
                request: CancelSimulationJobBatchRequest
            ): IO[
              AwsError,
              zio.aws.robomaker.model.CancelSimulationJobBatchResponse.ReadOnly
            ] = proxy(CancelSimulationJobBatch, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.robomaker.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def updateSimulationApplication(
                request: UpdateSimulationApplicationRequest
            ): IO[
              AwsError,
              zio.aws.robomaker.model.UpdateSimulationApplicationResponse.ReadOnly
            ] = proxy(UpdateSimulationApplication, request)
            def describeSimulationApplication(
                request: DescribeSimulationApplicationRequest
            ): IO[
              AwsError,
              zio.aws.robomaker.model.DescribeSimulationApplicationResponse.ReadOnly
            ] = proxy(DescribeSimulationApplication, request)
            def deleteSimulationApplication(
                request: DeleteSimulationApplicationRequest
            ): IO[
              AwsError,
              zio.aws.robomaker.model.DeleteSimulationApplicationResponse.ReadOnly
            ] = proxy(DeleteSimulationApplication, request)
            def listWorldTemplates(request: ListWorldTemplatesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.robomaker.model.TemplateSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListWorldTemplates, request)
                }
                .getOrThrowFiberFailure()
            }
            def listWorldTemplatesPaginated(
                request: ListWorldTemplatesRequest
            ): IO[
              AwsError,
              zio.aws.robomaker.model.ListWorldTemplatesResponse.ReadOnly
            ] = proxy(ListWorldTemplatesPaginated, request)
            def getWorldTemplateBody(request: GetWorldTemplateBodyRequest): IO[
              AwsError,
              zio.aws.robomaker.model.GetWorldTemplateBodyResponse.ReadOnly
            ] = proxy(GetWorldTemplateBody, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.robomaker.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def describeWorld(request: DescribeWorldRequest): IO[
              AwsError,
              zio.aws.robomaker.model.DescribeWorldResponse.ReadOnly
            ] = proxy(DescribeWorld, request)
            def tagResource(
                request: TagResourceRequest
            ): IO[AwsError, ReadOnly] = proxy(TagResource, request)
            def createSimulationApplication(
                request: CreateSimulationApplicationRequest
            ): IO[
              AwsError,
              zio.aws.robomaker.model.CreateSimulationApplicationResponse.ReadOnly
            ] = proxy(CreateSimulationApplication, request)
            def cancelWorldGenerationJob(
                request: CancelWorldGenerationJobRequest
            ): IO[
              AwsError,
              zio.aws.robomaker.model.CancelWorldGenerationJobResponse.ReadOnly
            ] = proxy(CancelWorldGenerationJob, request)
            def updateRobotApplication(
                request: UpdateRobotApplicationRequest
            ): IO[
              AwsError,
              zio.aws.robomaker.model.UpdateRobotApplicationResponse.ReadOnly
            ] = proxy(UpdateRobotApplication, request)
            def deleteRobotApplication(
                request: DeleteRobotApplicationRequest
            ): IO[
              AwsError,
              zio.aws.robomaker.model.DeleteRobotApplicationResponse.ReadOnly
            ] = proxy(DeleteRobotApplication, request)
            def listWorldExportJobs(
                request: ListWorldExportJobsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.robomaker.model.WorldExportJobSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListWorldExportJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listWorldExportJobsPaginated(
                request: ListWorldExportJobsRequest
            ): IO[
              AwsError,
              zio.aws.robomaker.model.ListWorldExportJobsResponse.ReadOnly
            ] = proxy(ListWorldExportJobsPaginated, request)
            def describeRobotApplication(
                request: DescribeRobotApplicationRequest
            ): IO[
              AwsError,
              zio.aws.robomaker.model.DescribeRobotApplicationResponse.ReadOnly
            ] = proxy(DescribeRobotApplication, request)
            def batchDeleteWorlds(request: BatchDeleteWorldsRequest): IO[
              AwsError,
              zio.aws.robomaker.model.BatchDeleteWorldsResponse.ReadOnly
            ] = proxy(BatchDeleteWorlds, request)
            def listWorldGenerationJobs(
                request: ListWorldGenerationJobsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.robomaker.model.WorldGenerationJobSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListWorldGenerationJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listWorldGenerationJobsPaginated(
                request: ListWorldGenerationJobsRequest
            ): IO[
              AwsError,
              zio.aws.robomaker.model.ListWorldGenerationJobsResponse.ReadOnly
            ] = proxy(ListWorldGenerationJobsPaginated, request)
          }
        }
      }
    }
  }
}
