package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.robomaker.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class BatchDeleteWorldsRequest(worlds: Iterable[Arn]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.BatchDeleteWorldsRequest = {
    import BatchDeleteWorldsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.BatchDeleteWorldsRequest
      .builder()
      .worlds(worlds.map { item =>
        Arn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.BatchDeleteWorldsRequest.ReadOnly =
    zio.aws.robomaker.model.BatchDeleteWorldsRequest.wrap(buildAwsValue())
}
object BatchDeleteWorldsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.BatchDeleteWorldsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.BatchDeleteWorldsRequest =
      zio.aws.robomaker.model.BatchDeleteWorldsRequest(worlds)
    def worlds: List[Arn]
    def getWorlds: ZIO[Any, Nothing, List[Arn]] = ZIO.succeed(worlds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.BatchDeleteWorldsRequest
  ) extends zio.aws.robomaker.model.BatchDeleteWorldsRequest.ReadOnly {
    override val worlds: List[Arn] = impl
      .worlds()
      .asScala
      .map { item =>
        zio.aws.robomaker.model.primitives.Arn(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.BatchDeleteWorldsRequest
  ): zio.aws.robomaker.model.BatchDeleteWorldsRequest.ReadOnly = new Wrapper(
    impl
  )
}
