package zio.aws.robomaker.model
import zio.aws.robomaker.model.primitives.{
  MaxConcurrency,
  BatchTimeoutInSeconds
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class BatchPolicy(
    timeoutInSeconds: Optional[BatchTimeoutInSeconds] = Optional.Absent,
    maxConcurrency: Optional[MaxConcurrency] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.BatchPolicy = {
    import BatchPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.BatchPolicy
      .builder()
      .optionallyWith(
        timeoutInSeconds.map(value =>
          BatchTimeoutInSeconds.unwrap(value): java.lang.Long
        )
      )(_.timeoutInSeconds)
      .optionallyWith(
        maxConcurrency.map(value => MaxConcurrency.unwrap(value): Integer)
      )(_.maxConcurrency)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.BatchPolicy.ReadOnly =
    zio.aws.robomaker.model.BatchPolicy.wrap(buildAwsValue())
}
object BatchPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.BatchPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.BatchPolicy =
      zio.aws.robomaker.model.BatchPolicy(
        timeoutInSeconds.map(value => value),
        maxConcurrency.map(value => value)
      )
    def timeoutInSeconds: Optional[BatchTimeoutInSeconds]
    def maxConcurrency: Optional[MaxConcurrency]
    def getTimeoutInSeconds: ZIO[Any, AwsError, BatchTimeoutInSeconds] =
      AwsError.unwrapOptionField("timeoutInSeconds", timeoutInSeconds)
    def getMaxConcurrency: ZIO[Any, AwsError, MaxConcurrency] =
      AwsError.unwrapOptionField("maxConcurrency", maxConcurrency)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.BatchPolicy
  ) extends zio.aws.robomaker.model.BatchPolicy.ReadOnly {
    override val timeoutInSeconds: Optional[BatchTimeoutInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeoutInSeconds())
        .map(value =>
          zio.aws.robomaker.model.primitives.BatchTimeoutInSeconds(value)
        )
    override val maxConcurrency: Optional[MaxConcurrency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxConcurrency())
        .map(value => zio.aws.robomaker.model.primitives.MaxConcurrency(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.BatchPolicy
  ): zio.aws.robomaker.model.BatchPolicy.ReadOnly = new Wrapper(impl)
}
