package zio.aws.robomaker.model
import zio.aws.robomaker.model.primitives.{
  CreatedAt,
  ClientRequestToken,
  TagValue,
  Arn,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CreateWorldGenerationJobResponse(
    arn: Optional[Arn] = Optional.Absent,
    status: Optional[zio.aws.robomaker.model.WorldGenerationJobStatus] =
      Optional.Absent,
    createdAt: Optional[CreatedAt] = Optional.Absent,
    failureCode: Optional[zio.aws.robomaker.model.WorldGenerationJobErrorCode] =
      Optional.Absent,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    template: Optional[Arn] = Optional.Absent,
    worldCount: Optional[zio.aws.robomaker.model.WorldCount] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    worldTags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.CreateWorldGenerationJobResponse = {
    import CreateWorldGenerationJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.CreateWorldGenerationJobResponse
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(failureCode.map(value => value.unwrap))(_.failureCode)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        template.map(value => Arn.unwrap(value): java.lang.String)
      )(_.template)
      .optionallyWith(worldCount.map(value => value.buildAwsValue()))(
        _.worldCount
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        worldTags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.worldTags)
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.CreateWorldGenerationJobResponse.ReadOnly =
    zio.aws.robomaker.model.CreateWorldGenerationJobResponse
      .wrap(buildAwsValue())
}
object CreateWorldGenerationJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.CreateWorldGenerationJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.CreateWorldGenerationJobResponse =
      zio.aws.robomaker.model.CreateWorldGenerationJobResponse(
        arn.map(value => value),
        status.map(value => value),
        createdAt.map(value => value),
        failureCode.map(value => value),
        clientRequestToken.map(value => value),
        template.map(value => value),
        worldCount.map(value => value.asEditable),
        tags.map(value => value),
        worldTags.map(value => value)
      )
    def arn: Optional[Arn]
    def status: Optional[zio.aws.robomaker.model.WorldGenerationJobStatus]
    def createdAt: Optional[CreatedAt]
    def failureCode
        : Optional[zio.aws.robomaker.model.WorldGenerationJobErrorCode]
    def clientRequestToken: Optional[ClientRequestToken]
    def template: Optional[Arn]
    def worldCount: Optional[zio.aws.robomaker.model.WorldCount.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def worldTags: Optional[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.robomaker.model.WorldGenerationJobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getFailureCode: ZIO[
      Any,
      AwsError,
      zio.aws.robomaker.model.WorldGenerationJobErrorCode
    ] = AwsError.unwrapOptionField("failureCode", failureCode)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getTemplate: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("template", template)
    def getWorldCount
        : ZIO[Any, AwsError, zio.aws.robomaker.model.WorldCount.ReadOnly] =
      AwsError.unwrapOptionField("worldCount", worldCount)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getWorldTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("worldTags", worldTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.CreateWorldGenerationJobResponse
  ) extends zio.aws.robomaker.model.CreateWorldGenerationJobResponse.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val status
        : Optional[zio.aws.robomaker.model.WorldGenerationJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.robomaker.model.WorldGenerationJobStatus.wrap(value)
        )
    override val createdAt: Optional[CreatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.robomaker.model.primitives.CreatedAt(value))
    override val failureCode
        : Optional[zio.aws.robomaker.model.WorldGenerationJobErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureCode())
        .map(value =>
          zio.aws.robomaker.model.WorldGenerationJobErrorCode.wrap(value)
        )
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.robomaker.model.primitives.ClientRequestToken(value)
        )
    override val template: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.template())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val worldCount
        : Optional[zio.aws.robomaker.model.WorldCount.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.worldCount())
        .map(value => zio.aws.robomaker.model.WorldCount.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.robomaker.model.primitives
              .TagKey(key) -> zio.aws.robomaker.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val worldTags: Optional[Map[TagKey, TagValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.worldTags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.robomaker.model.primitives.TagKey(
                key
              ) -> zio.aws.robomaker.model.primitives.TagValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.CreateWorldGenerationJobResponse
  ): zio.aws.robomaker.model.CreateWorldGenerationJobResponse.ReadOnly =
    new Wrapper(impl)
}
