package zio.aws.robomaker.model
import scala.jdk.CollectionConverters._
sealed trait DeploymentJobErrorCode {
  def unwrap
      : software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode
}
object DeploymentJobErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode
  ): zio.aws.robomaker.model.DeploymentJobErrorCode = value match {
    case software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.RESOURCE_NOT_FOUND =>
      val r = ResourceNotFound
      r
    case software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.ENVIRONMENT_SETUP_ERROR =>
      val r = EnvironmentSetupError
      r
    case software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.ETAG_MISMATCH =>
      val r = EtagMismatch
      r
    case software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.FAILURE_THRESHOLD_BREACHED =>
      val r = FailureThresholdBreached
      r
    case software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.ROBOT_DEPLOYMENT_ABORTED =>
      val r = RobotDeploymentAborted
      r
    case software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.ROBOT_DEPLOYMENT_NO_RESPONSE =>
      val r = RobotDeploymentNoResponse
      r
    case software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.ROBOT_AGENT_CONNECTION_TIMEOUT =>
      val r = RobotAgentConnectionTimeout
      r
    case software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.GREENGRASS_DEPLOYMENT_FAILED =>
      val r = GreengrassDeploymentFailed
      r
    case software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.INVALID_GREENGRASS_GROUP =>
      val r = InvalidGreengrassGroup
      r
    case software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.MISSING_ROBOT_ARCHITECTURE =>
      val r = MissingRobotArchitecture
      r
    case software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.MISSING_ROBOT_APPLICATION_ARCHITECTURE =>
      val r = MissingRobotApplicationArchitecture
      r
    case software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.MISSING_ROBOT_DEPLOYMENT_RESOURCE =>
      val r = MissingRobotDeploymentResource
      r
    case software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.GREENGRASS_GROUP_VERSION_DOES_NOT_EXIST =>
      val r = GreengrassGroupVersionDoesNotExist
      r
    case software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.LAMBDA_DELETED =>
      val r = LambdaDeleted
      r
    case software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.EXTRACTING_BUNDLE_FAILURE =>
      val r = ExtractingBundleFailure
      r
    case software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.PRE_LAUNCH_FILE_FAILURE =>
      val r = PreLaunchFileFailure
      r
    case software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.POST_LAUNCH_FILE_FAILURE =>
      val r = PostLaunchFileFailure
      r
    case software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.BAD_PERMISSION_ERROR =>
      val r = BadPermissionError
      r
    case software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.DOWNLOAD_CONDITION_FAILED =>
      val r = DownloadConditionFailed
      r
    case software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.BAD_LAMBDA_ASSOCIATED =>
      val r = BadLambdaAssociated
      r
    case software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.INTERNAL_SERVER_ERROR =>
      val r = InternalServerError
      r
    case software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.ROBOT_APPLICATION_DOES_NOT_EXIST =>
      val r = RobotApplicationDoesNotExist
      r
    case software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.DEPLOYMENT_FLEET_DOES_NOT_EXIST =>
      val r = DeploymentFleetDoesNotExist
      r
    case software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.FLEET_DEPLOYMENT_TIMEOUT =>
      val r = FleetDeploymentTimeout
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.robomaker.model.DeploymentJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object ResourceNotFound
      extends zio.aws.robomaker.model.DeploymentJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.RESOURCE_NOT_FOUND
  }
  case object EnvironmentSetupError
      extends zio.aws.robomaker.model.DeploymentJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.ENVIRONMENT_SETUP_ERROR
  }
  case object EtagMismatch
      extends zio.aws.robomaker.model.DeploymentJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.ETAG_MISMATCH
  }
  case object FailureThresholdBreached
      extends zio.aws.robomaker.model.DeploymentJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.FAILURE_THRESHOLD_BREACHED
  }
  case object RobotDeploymentAborted
      extends zio.aws.robomaker.model.DeploymentJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.ROBOT_DEPLOYMENT_ABORTED
  }
  case object RobotDeploymentNoResponse
      extends zio.aws.robomaker.model.DeploymentJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.ROBOT_DEPLOYMENT_NO_RESPONSE
  }
  case object RobotAgentConnectionTimeout
      extends zio.aws.robomaker.model.DeploymentJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.ROBOT_AGENT_CONNECTION_TIMEOUT
  }
  case object GreengrassDeploymentFailed
      extends zio.aws.robomaker.model.DeploymentJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.GREENGRASS_DEPLOYMENT_FAILED
  }
  case object InvalidGreengrassGroup
      extends zio.aws.robomaker.model.DeploymentJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.INVALID_GREENGRASS_GROUP
  }
  case object MissingRobotArchitecture
      extends zio.aws.robomaker.model.DeploymentJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.MISSING_ROBOT_ARCHITECTURE
  }
  case object MissingRobotApplicationArchitecture
      extends zio.aws.robomaker.model.DeploymentJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.MISSING_ROBOT_APPLICATION_ARCHITECTURE
  }
  case object MissingRobotDeploymentResource
      extends zio.aws.robomaker.model.DeploymentJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.MISSING_ROBOT_DEPLOYMENT_RESOURCE
  }
  case object GreengrassGroupVersionDoesNotExist
      extends zio.aws.robomaker.model.DeploymentJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.GREENGRASS_GROUP_VERSION_DOES_NOT_EXIST
  }
  case object LambdaDeleted
      extends zio.aws.robomaker.model.DeploymentJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.LAMBDA_DELETED
  }
  case object ExtractingBundleFailure
      extends zio.aws.robomaker.model.DeploymentJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.EXTRACTING_BUNDLE_FAILURE
  }
  case object PreLaunchFileFailure
      extends zio.aws.robomaker.model.DeploymentJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.PRE_LAUNCH_FILE_FAILURE
  }
  case object PostLaunchFileFailure
      extends zio.aws.robomaker.model.DeploymentJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.POST_LAUNCH_FILE_FAILURE
  }
  case object BadPermissionError
      extends zio.aws.robomaker.model.DeploymentJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.BAD_PERMISSION_ERROR
  }
  case object DownloadConditionFailed
      extends zio.aws.robomaker.model.DeploymentJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.DOWNLOAD_CONDITION_FAILED
  }
  case object BadLambdaAssociated
      extends zio.aws.robomaker.model.DeploymentJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.BAD_LAMBDA_ASSOCIATED
  }
  case object InternalServerError
      extends zio.aws.robomaker.model.DeploymentJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.INTERNAL_SERVER_ERROR
  }
  case object RobotApplicationDoesNotExist
      extends zio.aws.robomaker.model.DeploymentJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.ROBOT_APPLICATION_DOES_NOT_EXIST
  }
  case object DeploymentFleetDoesNotExist
      extends zio.aws.robomaker.model.DeploymentJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.DEPLOYMENT_FLEET_DOES_NOT_EXIST
  }
  case object FleetDeploymentTimeout
      extends zio.aws.robomaker.model.DeploymentJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode.FLEET_DEPLOYMENT_TIMEOUT
  }
}
