package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.robomaker.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class DescribeWorldTemplateRequest(template: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.DescribeWorldTemplateRequest = {
    import DescribeWorldTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.DescribeWorldTemplateRequest
      .builder()
      .template(Arn.unwrap(template): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.DescribeWorldTemplateRequest.ReadOnly =
    zio.aws.robomaker.model.DescribeWorldTemplateRequest.wrap(buildAwsValue())
}
object DescribeWorldTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.DescribeWorldTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.DescribeWorldTemplateRequest =
      zio.aws.robomaker.model.DescribeWorldTemplateRequest(template)
    def template: Arn
    def getTemplate: ZIO[Any, Nothing, Arn] = ZIO.succeed(template)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeWorldTemplateRequest
  ) extends zio.aws.robomaker.model.DescribeWorldTemplateRequest.ReadOnly {
    override val template: Arn =
      zio.aws.robomaker.model.primitives.Arn(impl.template())
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeWorldTemplateRequest
  ): zio.aws.robomaker.model.DescribeWorldTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
