package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.robomaker.model.primitives.{Arn, Integer}
import scala.jdk.CollectionConverters._
final case class FinishedWorldsSummary(
    finishedCount: Optional[Integer] = Optional.Absent,
    succeededWorlds: Optional[Iterable[Arn]] = Optional.Absent,
    failureSummary: Optional[zio.aws.robomaker.model.FailureSummary] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.FinishedWorldsSummary = {
    import FinishedWorldsSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.FinishedWorldsSummary
      .builder()
      .optionallyWith(finishedCount.map(value => value: java.lang.Integer))(
        _.finishedCount
      )
      .optionallyWith(
        succeededWorlds.map(value =>
          value.map { item =>
            Arn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.succeededWorlds)
      .optionallyWith(failureSummary.map(value => value.buildAwsValue()))(
        _.failureSummary
      )
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.FinishedWorldsSummary.ReadOnly =
    zio.aws.robomaker.model.FinishedWorldsSummary.wrap(buildAwsValue())
}
object FinishedWorldsSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.FinishedWorldsSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.FinishedWorldsSummary =
      zio.aws.robomaker.model.FinishedWorldsSummary(
        finishedCount.map(value => value),
        succeededWorlds.map(value => value),
        failureSummary.map(value => value.asEditable)
      )
    def finishedCount: Optional[Integer]
    def succeededWorlds: Optional[List[Arn]]
    def failureSummary
        : Optional[zio.aws.robomaker.model.FailureSummary.ReadOnly]
    def getFinishedCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("finishedCount", finishedCount)
    def getSucceededWorlds: ZIO[Any, AwsError, List[Arn]] =
      AwsError.unwrapOptionField("succeededWorlds", succeededWorlds)
    def getFailureSummary
        : ZIO[Any, AwsError, zio.aws.robomaker.model.FailureSummary.ReadOnly] =
      AwsError.unwrapOptionField("failureSummary", failureSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.FinishedWorldsSummary
  ) extends zio.aws.robomaker.model.FinishedWorldsSummary.ReadOnly {
    override val finishedCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.finishedCount())
      .map(value => value: Integer)
    override val succeededWorlds: Optional[List[Arn]] = zio.aws.core.internal
      .optionalFromNullable(impl.succeededWorlds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.primitives.Arn(item)
        }.toList
      )
    override val failureSummary
        : Optional[zio.aws.robomaker.model.FailureSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureSummary())
        .map(value => zio.aws.robomaker.model.FailureSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.FinishedWorldsSummary
  ): zio.aws.robomaker.model.FinishedWorldsSummary.ReadOnly = new Wrapper(impl)
}
