package zio.aws.robomaker.model
import zio.aws.robomaker.model.primitives.{CreatedAt, Arn, Name}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Fleet(
    name: Optional[Name] = Optional.Absent,
    arn: Optional[Arn] = Optional.Absent,
    createdAt: Optional[CreatedAt] = Optional.Absent,
    lastDeploymentStatus: Optional[zio.aws.robomaker.model.DeploymentStatus] =
      Optional.Absent,
    lastDeploymentJob: Optional[Arn] = Optional.Absent,
    lastDeploymentTime: Optional[CreatedAt] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.robomaker.model.Fleet = {
    import Fleet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.Fleet
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(lastDeploymentStatus.map(value => value.unwrap))(
        _.lastDeploymentStatus
      )
      .optionallyWith(
        lastDeploymentJob.map(value => Arn.unwrap(value): java.lang.String)
      )(_.lastDeploymentJob)
      .optionallyWith(
        lastDeploymentTime.map(value => CreatedAt.unwrap(value): Instant)
      )(_.lastDeploymentTime)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.Fleet.ReadOnly =
    zio.aws.robomaker.model.Fleet.wrap(buildAwsValue())
}
object Fleet {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.robomaker.model.Fleet] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.Fleet =
      zio.aws.robomaker.model.Fleet(
        name.map(value => value),
        arn.map(value => value),
        createdAt.map(value => value),
        lastDeploymentStatus.map(value => value),
        lastDeploymentJob.map(value => value),
        lastDeploymentTime.map(value => value)
      )
    def name: Optional[Name]
    def arn: Optional[Arn]
    def createdAt: Optional[CreatedAt]
    def lastDeploymentStatus: Optional[zio.aws.robomaker.model.DeploymentStatus]
    def lastDeploymentJob: Optional[Arn]
    def lastDeploymentTime: Optional[CreatedAt]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastDeploymentStatus
        : ZIO[Any, AwsError, zio.aws.robomaker.model.DeploymentStatus] =
      AwsError.unwrapOptionField("lastDeploymentStatus", lastDeploymentStatus)
    def getLastDeploymentJob: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("lastDeploymentJob", lastDeploymentJob)
    def getLastDeploymentTime: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("lastDeploymentTime", lastDeploymentTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.Fleet
  ) extends zio.aws.robomaker.model.Fleet.ReadOnly {
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.robomaker.model.primitives.Name(value))
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val createdAt: Optional[CreatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.robomaker.model.primitives.CreatedAt(value))
    override val lastDeploymentStatus
        : Optional[zio.aws.robomaker.model.DeploymentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastDeploymentStatus())
        .map(value => zio.aws.robomaker.model.DeploymentStatus.wrap(value))
    override val lastDeploymentJob: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.lastDeploymentJob())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val lastDeploymentTime: Optional[CreatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.lastDeploymentTime())
      .map(value => zio.aws.robomaker.model.primitives.CreatedAt(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.Fleet
  ): zio.aws.robomaker.model.Fleet.ReadOnly = new Wrapper(impl)
}
