package zio.aws.robomaker.model
import zio.aws.robomaker.model.primitives.{Name, LastUpdatedAt, Arn}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class SimulationJobSummary(
    arn: Optional[Arn] = Optional.Absent,
    lastUpdatedAt: Optional[LastUpdatedAt] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    status: Optional[zio.aws.robomaker.model.SimulationJobStatus] =
      Optional.Absent,
    simulationApplicationNames: Optional[Iterable[Name]] = Optional.Absent,
    robotApplicationNames: Optional[Iterable[Name]] = Optional.Absent,
    dataSourceNames: Optional[Iterable[Name]] = Optional.Absent,
    computeType: Optional[zio.aws.robomaker.model.ComputeType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.SimulationJobSummary = {
    import SimulationJobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.SimulationJobSummary
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        lastUpdatedAt.map(value => LastUpdatedAt.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        simulationApplicationNames.map(value =>
          value.map { item =>
            Name.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.simulationApplicationNames)
      .optionallyWith(
        robotApplicationNames.map(value =>
          value.map { item =>
            Name.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.robotApplicationNames)
      .optionallyWith(
        dataSourceNames.map(value =>
          value.map { item =>
            Name.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dataSourceNames)
      .optionallyWith(computeType.map(value => value.unwrap))(_.computeType)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.SimulationJobSummary.ReadOnly =
    zio.aws.robomaker.model.SimulationJobSummary.wrap(buildAwsValue())
}
object SimulationJobSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.SimulationJobSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.SimulationJobSummary =
      zio.aws.robomaker.model.SimulationJobSummary(
        arn.map(value => value),
        lastUpdatedAt.map(value => value),
        name.map(value => value),
        status.map(value => value),
        simulationApplicationNames.map(value => value),
        robotApplicationNames.map(value => value),
        dataSourceNames.map(value => value),
        computeType.map(value => value)
      )
    def arn: Optional[Arn]
    def lastUpdatedAt: Optional[LastUpdatedAt]
    def name: Optional[Name]
    def status: Optional[zio.aws.robomaker.model.SimulationJobStatus]
    def simulationApplicationNames: Optional[List[Name]]
    def robotApplicationNames: Optional[List[Name]]
    def dataSourceNames: Optional[List[Name]]
    def computeType: Optional[zio.aws.robomaker.model.ComputeType]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getLastUpdatedAt: ZIO[Any, AwsError, LastUpdatedAt] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.robomaker.model.SimulationJobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSimulationApplicationNames: ZIO[Any, AwsError, List[Name]] =
      AwsError.unwrapOptionField(
        "simulationApplicationNames",
        simulationApplicationNames
      )
    def getRobotApplicationNames: ZIO[Any, AwsError, List[Name]] =
      AwsError.unwrapOptionField("robotApplicationNames", robotApplicationNames)
    def getDataSourceNames: ZIO[Any, AwsError, List[Name]] =
      AwsError.unwrapOptionField("dataSourceNames", dataSourceNames)
    def getComputeType
        : ZIO[Any, AwsError, zio.aws.robomaker.model.ComputeType] =
      AwsError.unwrapOptionField("computeType", computeType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.SimulationJobSummary
  ) extends zio.aws.robomaker.model.SimulationJobSummary.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val lastUpdatedAt: Optional[LastUpdatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.robomaker.model.primitives.LastUpdatedAt(value))
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.robomaker.model.primitives.Name(value))
    override val status: Optional[zio.aws.robomaker.model.SimulationJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.robomaker.model.SimulationJobStatus.wrap(value))
    override val simulationApplicationNames: Optional[List[Name]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.simulationApplicationNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.robomaker.model.primitives.Name(item)
          }.toList
        )
    override val robotApplicationNames: Optional[List[Name]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.robotApplicationNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.robomaker.model.primitives.Name(item)
          }.toList
        )
    override val dataSourceNames: Optional[List[Name]] = zio.aws.core.internal
      .optionalFromNullable(impl.dataSourceNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.primitives.Name(item)
        }.toList
      )
    override val computeType: Optional[zio.aws.robomaker.model.ComputeType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.computeType())
        .map(value => zio.aws.robomaker.model.ComputeType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.SimulationJobSummary
  ): zio.aws.robomaker.model.SimulationJobSummary.ReadOnly = new Wrapper(impl)
}
