package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.robomaker.model.primitives.{RevisionId, Arn}
import scala.jdk.CollectionConverters._
final case class UpdateRobotApplicationRequest(
    application: Arn,
    sources: Optional[Iterable[zio.aws.robomaker.model.SourceConfig]] =
      Optional.Absent,
    robotSoftwareSuite: zio.aws.robomaker.model.RobotSoftwareSuite,
    currentRevisionId: Optional[RevisionId] = Optional.Absent,
    environment: Optional[zio.aws.robomaker.model.Environment] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.UpdateRobotApplicationRequest = {
    import UpdateRobotApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.UpdateRobotApplicationRequest
      .builder()
      .application(Arn.unwrap(application): java.lang.String)
      .optionallyWith(
        sources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sources)
      .robotSoftwareSuite(robotSoftwareSuite.buildAwsValue())
      .optionallyWith(
        currentRevisionId.map(value =>
          RevisionId.unwrap(value): java.lang.String
        )
      )(_.currentRevisionId)
      .optionallyWith(environment.map(value => value.buildAwsValue()))(
        _.environment
      )
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.UpdateRobotApplicationRequest.ReadOnly =
    zio.aws.robomaker.model.UpdateRobotApplicationRequest.wrap(buildAwsValue())
}
object UpdateRobotApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.UpdateRobotApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.UpdateRobotApplicationRequest =
      zio.aws.robomaker.model.UpdateRobotApplicationRequest(
        application,
        sources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        robotSoftwareSuite.asEditable,
        currentRevisionId.map(value => value),
        environment.map(value => value.asEditable)
      )
    def application: Arn
    def sources: Optional[List[zio.aws.robomaker.model.SourceConfig.ReadOnly]]
    def robotSoftwareSuite: zio.aws.robomaker.model.RobotSoftwareSuite.ReadOnly
    def currentRevisionId: Optional[RevisionId]
    def environment: Optional[zio.aws.robomaker.model.Environment.ReadOnly]
    def getApplication: ZIO[Any, Nothing, Arn] = ZIO.succeed(application)
    def getSources: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.SourceConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("sources", sources)
    def getRobotSoftwareSuite: ZIO[
      Any,
      Nothing,
      zio.aws.robomaker.model.RobotSoftwareSuite.ReadOnly
    ] = ZIO.succeed(robotSoftwareSuite)
    def getCurrentRevisionId: ZIO[Any, AwsError, RevisionId] =
      AwsError.unwrapOptionField("currentRevisionId", currentRevisionId)
    def getEnvironment
        : ZIO[Any, AwsError, zio.aws.robomaker.model.Environment.ReadOnly] =
      AwsError.unwrapOptionField("environment", environment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.UpdateRobotApplicationRequest
  ) extends zio.aws.robomaker.model.UpdateRobotApplicationRequest.ReadOnly {
    override val application: Arn =
      zio.aws.robomaker.model.primitives.Arn(impl.application())
    override val sources
        : Optional[List[zio.aws.robomaker.model.SourceConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.robomaker.model.SourceConfig.wrap(item)
          }.toList
        )
    override val robotSoftwareSuite
        : zio.aws.robomaker.model.RobotSoftwareSuite.ReadOnly =
      zio.aws.robomaker.model.RobotSoftwareSuite.wrap(impl.robotSoftwareSuite())
    override val currentRevisionId: Optional[RevisionId] = zio.aws.core.internal
      .optionalFromNullable(impl.currentRevisionId())
      .map(value => zio.aws.robomaker.model.primitives.RevisionId(value))
    override val environment
        : Optional[zio.aws.robomaker.model.Environment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environment())
        .map(value => zio.aws.robomaker.model.Environment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.UpdateRobotApplicationRequest
  ): zio.aws.robomaker.model.UpdateRobotApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
