package zio.aws.robomaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.{
  MaxConcurrency,
  BatchTimeoutInSeconds
}
import scala.jdk.CollectionConverters.*
final case class BatchPolicy(
    timeoutInSeconds: Option[BatchTimeoutInSeconds] = None,
    maxConcurrency: Option[MaxConcurrency] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.BatchPolicy = {
    import BatchPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.BatchPolicy
      .builder()
      .optionallyWith(
        timeoutInSeconds.map(value =>
          BatchTimeoutInSeconds.unwrap(value): java.lang.Long
        )
      )(_.timeoutInSeconds)
      .optionallyWith(
        maxConcurrency.map(value => MaxConcurrency.unwrap(value): Integer)
      )(_.maxConcurrency)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.BatchPolicy.ReadOnly =
    zio.aws.robomaker.model.BatchPolicy.wrap(buildAwsValue())
}
object BatchPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.BatchPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.BatchPolicy =
      zio.aws.robomaker.model.BatchPolicy(
        timeoutInSeconds.map(value => value),
        maxConcurrency.map(value => value)
      )
    def timeoutInSeconds: Option[BatchTimeoutInSeconds]
    def maxConcurrency: Option[MaxConcurrency]
    def getTimeoutInSeconds: ZIO[Any, AwsError, BatchTimeoutInSeconds] =
      AwsError.unwrapOptionField("timeoutInSeconds", timeoutInSeconds)
    def getMaxConcurrency: ZIO[Any, AwsError, MaxConcurrency] =
      AwsError.unwrapOptionField("maxConcurrency", maxConcurrency)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.BatchPolicy
  ) extends zio.aws.robomaker.model.BatchPolicy.ReadOnly {
    override val timeoutInSeconds: Option[BatchTimeoutInSeconds] = scala
      .Option(impl.timeoutInSeconds())
      .map(value =>
        zio.aws.robomaker.model.primitives.BatchTimeoutInSeconds(value)
      )
    override val maxConcurrency: Option[MaxConcurrency] = scala
      .Option(impl.maxConcurrency())
      .map(value => zio.aws.robomaker.model.primitives.MaxConcurrency(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.BatchPolicy
  ): zio.aws.robomaker.model.BatchPolicy.ReadOnly = new Wrapper(impl)
}
