package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.{TagValue, TagKey, Name}
import scala.jdk.CollectionConverters.*
final case class CreateSimulationApplicationRequest(
    name: Name,
    sources: Option[Iterable[zio.aws.robomaker.model.SourceConfig]] = None,
    simulationSoftwareSuite: zio.aws.robomaker.model.SimulationSoftwareSuite,
    robotSoftwareSuite: zio.aws.robomaker.model.RobotSoftwareSuite,
    renderingEngine: Option[zio.aws.robomaker.model.RenderingEngine] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    environment: Option[zio.aws.robomaker.model.Environment] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.CreateSimulationApplicationRequest = {
    import CreateSimulationApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.CreateSimulationApplicationRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        sources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sources)
      .simulationSoftwareSuite(simulationSoftwareSuite.buildAwsValue())
      .robotSoftwareSuite(robotSoftwareSuite.buildAwsValue())
      .optionallyWith(renderingEngine.map(value => value.buildAwsValue()))(
        _.renderingEngine
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(environment.map(value => value.buildAwsValue()))(
        _.environment
      )
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.CreateSimulationApplicationRequest.ReadOnly =
    zio.aws.robomaker.model.CreateSimulationApplicationRequest
      .wrap(buildAwsValue())
}
object CreateSimulationApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.CreateSimulationApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.CreateSimulationApplicationRequest =
      zio.aws.robomaker.model.CreateSimulationApplicationRequest(
        name,
        sources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        simulationSoftwareSuite.asEditable,
        robotSoftwareSuite.asEditable,
        renderingEngine.map(value => value.asEditable),
        tags.map(value => value),
        environment.map(value => value.asEditable)
      )
    def name: Name
    def sources: Option[List[zio.aws.robomaker.model.SourceConfig.ReadOnly]]
    def simulationSoftwareSuite
        : zio.aws.robomaker.model.SimulationSoftwareSuite.ReadOnly
    def robotSoftwareSuite: zio.aws.robomaker.model.RobotSoftwareSuite.ReadOnly
    def renderingEngine
        : Option[zio.aws.robomaker.model.RenderingEngine.ReadOnly]
    def tags: Option[Map[TagKey, TagValue]]
    def environment: Option[zio.aws.robomaker.model.Environment.ReadOnly]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getSources: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.SourceConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("sources", sources)
    def getSimulationSoftwareSuite: ZIO[
      Any,
      Nothing,
      zio.aws.robomaker.model.SimulationSoftwareSuite.ReadOnly
    ] = ZIO.succeed(simulationSoftwareSuite)
    def getRobotSoftwareSuite: ZIO[
      Any,
      Nothing,
      zio.aws.robomaker.model.RobotSoftwareSuite.ReadOnly
    ] = ZIO.succeed(robotSoftwareSuite)
    def getRenderingEngine
        : ZIO[Any, AwsError, zio.aws.robomaker.model.RenderingEngine.ReadOnly] =
      AwsError.unwrapOptionField("renderingEngine", renderingEngine)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getEnvironment
        : ZIO[Any, AwsError, zio.aws.robomaker.model.Environment.ReadOnly] =
      AwsError.unwrapOptionField("environment", environment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.CreateSimulationApplicationRequest
  ) extends zio.aws.robomaker.model.CreateSimulationApplicationRequest.ReadOnly {
    override val name: Name =
      zio.aws.robomaker.model.primitives.Name(impl.name())
    override val sources
        : Option[List[zio.aws.robomaker.model.SourceConfig.ReadOnly]] = scala
      .Option(impl.sources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.SourceConfig.wrap(item)
        }.toList
      )
    override val simulationSoftwareSuite
        : zio.aws.robomaker.model.SimulationSoftwareSuite.ReadOnly =
      zio.aws.robomaker.model.SimulationSoftwareSuite
        .wrap(impl.simulationSoftwareSuite())
    override val robotSoftwareSuite
        : zio.aws.robomaker.model.RobotSoftwareSuite.ReadOnly =
      zio.aws.robomaker.model.RobotSoftwareSuite.wrap(impl.robotSoftwareSuite())
    override val renderingEngine
        : Option[zio.aws.robomaker.model.RenderingEngine.ReadOnly] = scala
      .Option(impl.renderingEngine())
      .map(value => zio.aws.robomaker.model.RenderingEngine.wrap(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.robomaker.model.primitives
              .TagKey(key) -> zio.aws.robomaker.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val environment
        : Option[zio.aws.robomaker.model.Environment.ReadOnly] = scala
      .Option(impl.environment())
      .map(value => zio.aws.robomaker.model.Environment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.CreateSimulationApplicationRequest
  ): zio.aws.robomaker.model.CreateSimulationApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
