package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.{ImageDigest, S3Etag, RevisionId, Arn}
import scala.jdk.CollectionConverters.*
final case class CreateSimulationApplicationVersionRequest(
    application: Arn,
    currentRevisionId: Option[RevisionId] = None,
    s3Etags: Option[Iterable[S3Etag]] = None,
    imageDigest: Option[ImageDigest] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.CreateSimulationApplicationVersionRequest = {
    import CreateSimulationApplicationVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.CreateSimulationApplicationVersionRequest
      .builder()
      .application(Arn.unwrap(application): java.lang.String)
      .optionallyWith(
        currentRevisionId.map(value =>
          RevisionId.unwrap(value): java.lang.String
        )
      )(_.currentRevisionId)
      .optionallyWith(
        s3Etags.map(value =>
          value.map { item =>
            S3Etag.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.s3Etags)
      .optionallyWith(
        imageDigest.map(value => ImageDigest.unwrap(value): java.lang.String)
      )(_.imageDigest)
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.CreateSimulationApplicationVersionRequest.ReadOnly =
    zio.aws.robomaker.model.CreateSimulationApplicationVersionRequest
      .wrap(buildAwsValue())
}
object CreateSimulationApplicationVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.CreateSimulationApplicationVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.robomaker.model.CreateSimulationApplicationVersionRequest =
      zio.aws.robomaker.model.CreateSimulationApplicationVersionRequest(
        application,
        currentRevisionId.map(value => value),
        s3Etags.map(value => value),
        imageDigest.map(value => value)
      )
    def application: Arn
    def currentRevisionId: Option[RevisionId]
    def s3Etags: Option[List[S3Etag]]
    def imageDigest: Option[ImageDigest]
    def getApplication: ZIO[Any, Nothing, Arn] = ZIO.succeed(application)
    def getCurrentRevisionId: ZIO[Any, AwsError, RevisionId] =
      AwsError.unwrapOptionField("currentRevisionId", currentRevisionId)
    def getS3Etags: ZIO[Any, AwsError, List[S3Etag]] =
      AwsError.unwrapOptionField("s3Etags", s3Etags)
    def getImageDigest: ZIO[Any, AwsError, ImageDigest] =
      AwsError.unwrapOptionField("imageDigest", imageDigest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.CreateSimulationApplicationVersionRequest
  ) extends zio.aws.robomaker.model.CreateSimulationApplicationVersionRequest.ReadOnly {
    override val application: Arn =
      zio.aws.robomaker.model.primitives.Arn(impl.application())
    override val currentRevisionId: Option[RevisionId] = scala
      .Option(impl.currentRevisionId())
      .map(value => zio.aws.robomaker.model.primitives.RevisionId(value))
    override val s3Etags: Option[List[S3Etag]] = scala
      .Option(impl.s3Etags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.primitives.S3Etag(item)
        }.toList
      )
    override val imageDigest: Option[ImageDigest] = scala
      .Option(impl.imageDigest())
      .map(value => zio.aws.robomaker.model.primitives.ImageDigest(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.CreateSimulationApplicationVersionRequest
  ): zio.aws.robomaker.model.CreateSimulationApplicationVersionRequest.ReadOnly =
    new Wrapper(impl)
}
