package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.robomaker.model.primitives.{
  CreatedAt,
  ClientRequestToken,
  TagValue,
  Arn,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class CreateWorldGenerationJobResponse(
    arn: Option[Arn] = None,
    status: Option[zio.aws.robomaker.model.WorldGenerationJobStatus] = None,
    createdAt: Option[CreatedAt] = None,
    failureCode: Option[zio.aws.robomaker.model.WorldGenerationJobErrorCode] =
      None,
    clientRequestToken: Option[ClientRequestToken] = None,
    template: Option[Arn] = None,
    worldCount: Option[zio.aws.robomaker.model.WorldCount] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    worldTags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.CreateWorldGenerationJobResponse = {
    import CreateWorldGenerationJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.CreateWorldGenerationJobResponse
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(failureCode.map(value => value.unwrap))(_.failureCode)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        template.map(value => Arn.unwrap(value): java.lang.String)
      )(_.template)
      .optionallyWith(worldCount.map(value => value.buildAwsValue()))(
        _.worldCount
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        worldTags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.worldTags)
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.CreateWorldGenerationJobResponse.ReadOnly =
    zio.aws.robomaker.model.CreateWorldGenerationJobResponse
      .wrap(buildAwsValue())
}
object CreateWorldGenerationJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.CreateWorldGenerationJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.CreateWorldGenerationJobResponse =
      zio.aws.robomaker.model.CreateWorldGenerationJobResponse(
        arn.map(value => value),
        status.map(value => value),
        createdAt.map(value => value),
        failureCode.map(value => value),
        clientRequestToken.map(value => value),
        template.map(value => value),
        worldCount.map(value => value.asEditable),
        tags.map(value => value),
        worldTags.map(value => value)
      )
    def arn: Option[Arn]
    def status: Option[zio.aws.robomaker.model.WorldGenerationJobStatus]
    def createdAt: Option[CreatedAt]
    def failureCode: Option[zio.aws.robomaker.model.WorldGenerationJobErrorCode]
    def clientRequestToken: Option[ClientRequestToken]
    def template: Option[Arn]
    def worldCount: Option[zio.aws.robomaker.model.WorldCount.ReadOnly]
    def tags: Option[Map[TagKey, TagValue]]
    def worldTags: Option[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.robomaker.model.WorldGenerationJobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getFailureCode: ZIO[
      Any,
      AwsError,
      zio.aws.robomaker.model.WorldGenerationJobErrorCode
    ] = AwsError.unwrapOptionField("failureCode", failureCode)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getTemplate: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("template", template)
    def getWorldCount
        : ZIO[Any, AwsError, zio.aws.robomaker.model.WorldCount.ReadOnly] =
      AwsError.unwrapOptionField("worldCount", worldCount)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getWorldTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("worldTags", worldTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.CreateWorldGenerationJobResponse
  ) extends zio.aws.robomaker.model.CreateWorldGenerationJobResponse.ReadOnly {
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val status
        : Option[zio.aws.robomaker.model.WorldGenerationJobStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.robomaker.model.WorldGenerationJobStatus.wrap(value)
      )
    override val createdAt: Option[CreatedAt] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.robomaker.model.primitives.CreatedAt(value))
    override val failureCode
        : Option[zio.aws.robomaker.model.WorldGenerationJobErrorCode] = scala
      .Option(impl.failureCode())
      .map(value =>
        zio.aws.robomaker.model.WorldGenerationJobErrorCode.wrap(value)
      )
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.robomaker.model.primitives.ClientRequestToken(value)
      )
    override val template: Option[Arn] = scala
      .Option(impl.template())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val worldCount
        : Option[zio.aws.robomaker.model.WorldCount.ReadOnly] = scala
      .Option(impl.worldCount())
      .map(value => zio.aws.robomaker.model.WorldCount.wrap(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.robomaker.model.primitives
              .TagKey(key) -> zio.aws.robomaker.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val worldTags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.worldTags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.robomaker.model.primitives
              .TagKey(key) -> zio.aws.robomaker.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.CreateWorldGenerationJobResponse
  ): zio.aws.robomaker.model.CreateWorldGenerationJobResponse.ReadOnly =
    new Wrapper(impl)
}
