package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.robomaker.model.primitives.{
  CreatedAt,
  ClientRequestToken,
  TagValue,
  TemplateName,
  Arn,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class CreateWorldTemplateResponse(
    arn: Option[Arn] = None,
    clientRequestToken: Option[ClientRequestToken] = None,
    createdAt: Option[CreatedAt] = None,
    name: Option[TemplateName] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.CreateWorldTemplateResponse = {
    import CreateWorldTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.CreateWorldTemplateResponse
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        name.map(value => TemplateName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.CreateWorldTemplateResponse.ReadOnly =
    zio.aws.robomaker.model.CreateWorldTemplateResponse.wrap(buildAwsValue())
}
object CreateWorldTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.CreateWorldTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.CreateWorldTemplateResponse =
      zio.aws.robomaker.model.CreateWorldTemplateResponse(
        arn.map(value => value),
        clientRequestToken.map(value => value),
        createdAt.map(value => value),
        name.map(value => value),
        tags.map(value => value)
      )
    def arn: Option[Arn]
    def clientRequestToken: Option[ClientRequestToken]
    def createdAt: Option[CreatedAt]
    def name: Option[TemplateName]
    def tags: Option[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getName: ZIO[Any, AwsError, TemplateName] =
      AwsError.unwrapOptionField("name", name)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.CreateWorldTemplateResponse
  ) extends zio.aws.robomaker.model.CreateWorldTemplateResponse.ReadOnly {
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.robomaker.model.primitives.ClientRequestToken(value)
      )
    override val createdAt: Option[CreatedAt] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.robomaker.model.primitives.CreatedAt(value))
    override val name: Option[TemplateName] = scala
      .Option(impl.name())
      .map(value => zio.aws.robomaker.model.primitives.TemplateName(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.robomaker.model.primitives
              .TagKey(key) -> zio.aws.robomaker.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.CreateWorldTemplateResponse
  ): zio.aws.robomaker.model.CreateWorldTemplateResponse.ReadOnly = new Wrapper(
    impl
  )
}
