package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.{Path, S3Bucket, Name}
import scala.jdk.CollectionConverters.*
final case class DataSource(
    name: Option[Name] = None,
    s3Bucket: Option[S3Bucket] = None,
    s3Keys: Option[Iterable[zio.aws.robomaker.model.S3KeyOutput]] = None,
    `type`: Option[zio.aws.robomaker.model.DataSourceType] = None,
    destination: Option[Path] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.DataSource = {
    import DataSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.DataSource
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        s3Bucket.map(value => S3Bucket.unwrap(value): java.lang.String)
      )(_.s3Bucket)
      .optionallyWith(
        s3Keys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.s3Keys)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        destination.map(value => Path.unwrap(value): java.lang.String)
      )(_.destination)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.DataSource.ReadOnly =
    zio.aws.robomaker.model.DataSource.wrap(buildAwsValue())
}
object DataSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.DataSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.DataSource =
      zio.aws.robomaker.model.DataSource(
        name.map(value => value),
        s3Bucket.map(value => value),
        s3Keys.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        `type`.map(value => value),
        destination.map(value => value)
      )
    def name: Option[Name]
    def s3Bucket: Option[S3Bucket]
    def s3Keys: Option[List[zio.aws.robomaker.model.S3KeyOutput.ReadOnly]]
    def `type`: Option[zio.aws.robomaker.model.DataSourceType]
    def destination: Option[Path]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getS3Bucket: ZIO[Any, AwsError, S3Bucket] =
      AwsError.unwrapOptionField("s3Bucket", s3Bucket)
    def getS3Keys: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.S3KeyOutput.ReadOnly
    ]] = AwsError.unwrapOptionField("s3Keys", s3Keys)
    def getType: ZIO[Any, AwsError, zio.aws.robomaker.model.DataSourceType] =
      AwsError.unwrapOptionField("type", `type`)
    def getDestination: ZIO[Any, AwsError, Path] =
      AwsError.unwrapOptionField("destination", destination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.DataSource
  ) extends zio.aws.robomaker.model.DataSource.ReadOnly {
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.robomaker.model.primitives.Name(value))
    override val s3Bucket: Option[S3Bucket] = scala
      .Option(impl.s3Bucket())
      .map(value => zio.aws.robomaker.model.primitives.S3Bucket(value))
    override val s3Keys
        : Option[List[zio.aws.robomaker.model.S3KeyOutput.ReadOnly]] = scala
      .Option(impl.s3Keys())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.S3KeyOutput.wrap(item)
        }.toList
      )
    override val `type`: Option[zio.aws.robomaker.model.DataSourceType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.robomaker.model.DataSourceType.wrap(value))
    override val destination: Option[Path] = scala
      .Option(impl.destination())
      .map(value => zio.aws.robomaker.model.primitives.Path(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.DataSource
  ): zio.aws.robomaker.model.DataSource.ReadOnly = new Wrapper(impl)
}
