package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.{Version, Arn}
import scala.jdk.CollectionConverters.*
final case class DescribeSimulationApplicationRequest(
    application: Arn,
    applicationVersion: Option[Version] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.DescribeSimulationApplicationRequest = {
    import DescribeSimulationApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.DescribeSimulationApplicationRequest
      .builder()
      .application(Arn.unwrap(application): java.lang.String)
      .optionallyWith(
        applicationVersion.map(value => Version.unwrap(value): java.lang.String)
      )(_.applicationVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.DescribeSimulationApplicationRequest.ReadOnly =
    zio.aws.robomaker.model.DescribeSimulationApplicationRequest
      .wrap(buildAwsValue())
}
object DescribeSimulationApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.DescribeSimulationApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.robomaker.model.DescribeSimulationApplicationRequest =
      zio.aws.robomaker.model.DescribeSimulationApplicationRequest(
        application,
        applicationVersion.map(value => value)
      )
    def application: Arn
    def applicationVersion: Option[Version]
    def getApplication: ZIO[Any, Nothing, Arn] = ZIO.succeed(application)
    def getApplicationVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("applicationVersion", applicationVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeSimulationApplicationRequest
  ) extends zio.aws.robomaker.model.DescribeSimulationApplicationRequest.ReadOnly {
    override val application: Arn =
      zio.aws.robomaker.model.primitives.Arn(impl.application())
    override val applicationVersion: Option[Version] = scala
      .Option(impl.applicationVersion())
      .map(value => zio.aws.robomaker.model.primitives.Version(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeSimulationApplicationRequest
  ): zio.aws.robomaker.model.DescribeSimulationApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
