package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.robomaker.model.primitives.{
  Json,
  CreatedAt,
  TagValue,
  Arn,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class DescribeWorldResponse(
    arn: Option[Arn] = None,
    generationJob: Option[Arn] = None,
    template: Option[Arn] = None,
    createdAt: Option[CreatedAt] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    worldDescriptionBody: Option[Json] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.DescribeWorldResponse = {
    import DescribeWorldResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.DescribeWorldResponse
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        generationJob.map(value => Arn.unwrap(value): java.lang.String)
      )(_.generationJob)
      .optionallyWith(
        template.map(value => Arn.unwrap(value): java.lang.String)
      )(_.template)
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        worldDescriptionBody.map(value => Json.unwrap(value): java.lang.String)
      )(_.worldDescriptionBody)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.DescribeWorldResponse.ReadOnly =
    zio.aws.robomaker.model.DescribeWorldResponse.wrap(buildAwsValue())
}
object DescribeWorldResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.DescribeWorldResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.DescribeWorldResponse =
      zio.aws.robomaker.model.DescribeWorldResponse(
        arn.map(value => value),
        generationJob.map(value => value),
        template.map(value => value),
        createdAt.map(value => value),
        tags.map(value => value),
        worldDescriptionBody.map(value => value)
      )
    def arn: Option[Arn]
    def generationJob: Option[Arn]
    def template: Option[Arn]
    def createdAt: Option[CreatedAt]
    def tags: Option[Map[TagKey, TagValue]]
    def worldDescriptionBody: Option[Json]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getGenerationJob: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("generationJob", generationJob)
    def getTemplate: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("template", template)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getWorldDescriptionBody: ZIO[Any, AwsError, Json] =
      AwsError.unwrapOptionField("worldDescriptionBody", worldDescriptionBody)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeWorldResponse
  ) extends zio.aws.robomaker.model.DescribeWorldResponse.ReadOnly {
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val generationJob: Option[Arn] = scala
      .Option(impl.generationJob())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val template: Option[Arn] = scala
      .Option(impl.template())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val createdAt: Option[CreatedAt] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.robomaker.model.primitives.CreatedAt(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.robomaker.model.primitives
              .TagKey(key) -> zio.aws.robomaker.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val worldDescriptionBody: Option[Json] = scala
      .Option(impl.worldDescriptionBody())
      .map(value => zio.aws.robomaker.model.primitives.Json(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeWorldResponse
  ): zio.aws.robomaker.model.DescribeWorldResponse.ReadOnly = new Wrapper(impl)
}
