package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.robomaker.model.primitives.{CreatedAt, Arn, Name}
import scala.jdk.CollectionConverters.*
final case class Fleet(
    name: Option[Name] = None,
    arn: Option[Arn] = None,
    createdAt: Option[CreatedAt] = None,
    lastDeploymentStatus: Option[zio.aws.robomaker.model.DeploymentStatus] =
      None,
    lastDeploymentJob: Option[Arn] = None,
    lastDeploymentTime: Option[CreatedAt] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.robomaker.model.Fleet = {
    import Fleet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.Fleet
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(lastDeploymentStatus.map(value => value.unwrap))(
        _.lastDeploymentStatus
      )
      .optionallyWith(
        lastDeploymentJob.map(value => Arn.unwrap(value): java.lang.String)
      )(_.lastDeploymentJob)
      .optionallyWith(
        lastDeploymentTime.map(value => CreatedAt.unwrap(value): Instant)
      )(_.lastDeploymentTime)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.Fleet.ReadOnly =
    zio.aws.robomaker.model.Fleet.wrap(buildAwsValue())
}
object Fleet {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.robomaker.model.Fleet] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.Fleet =
      zio.aws.robomaker.model.Fleet(
        name.map(value => value),
        arn.map(value => value),
        createdAt.map(value => value),
        lastDeploymentStatus.map(value => value),
        lastDeploymentJob.map(value => value),
        lastDeploymentTime.map(value => value)
      )
    def name: Option[Name]
    def arn: Option[Arn]
    def createdAt: Option[CreatedAt]
    def lastDeploymentStatus: Option[zio.aws.robomaker.model.DeploymentStatus]
    def lastDeploymentJob: Option[Arn]
    def lastDeploymentTime: Option[CreatedAt]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastDeploymentStatus
        : ZIO[Any, AwsError, zio.aws.robomaker.model.DeploymentStatus] =
      AwsError.unwrapOptionField("lastDeploymentStatus", lastDeploymentStatus)
    def getLastDeploymentJob: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("lastDeploymentJob", lastDeploymentJob)
    def getLastDeploymentTime: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("lastDeploymentTime", lastDeploymentTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.Fleet
  ) extends zio.aws.robomaker.model.Fleet.ReadOnly {
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.robomaker.model.primitives.Name(value))
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val createdAt: Option[CreatedAt] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.robomaker.model.primitives.CreatedAt(value))
    override val lastDeploymentStatus
        : Option[zio.aws.robomaker.model.DeploymentStatus] = scala
      .Option(impl.lastDeploymentStatus())
      .map(value => zio.aws.robomaker.model.DeploymentStatus.wrap(value))
    override val lastDeploymentJob: Option[Arn] = scala
      .Option(impl.lastDeploymentJob())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val lastDeploymentTime: Option[CreatedAt] = scala
      .Option(impl.lastDeploymentTime())
      .map(value => zio.aws.robomaker.model.primitives.CreatedAt(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.Fleet
  ): zio.aws.robomaker.model.Fleet.ReadOnly = new Wrapper(impl)
}
