package zio.aws.robomaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.{MaxResults, PaginationToken}
import scala.jdk.CollectionConverters.*
final case class ListWorldExportJobsRequest(
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[MaxResults] = None,
    filters: Option[Iterable[zio.aws.robomaker.model.Filter]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.ListWorldExportJobsRequest = {
    import ListWorldExportJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.ListWorldExportJobsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.ListWorldExportJobsRequest.ReadOnly =
    zio.aws.robomaker.model.ListWorldExportJobsRequest.wrap(buildAwsValue())
}
object ListWorldExportJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.ListWorldExportJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.ListWorldExportJobsRequest =
      zio.aws.robomaker.model.ListWorldExportJobsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[PaginationToken]
    def maxResults: Option[MaxResults]
    def filters: Option[List[zio.aws.robomaker.model.Filter.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.robomaker.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.ListWorldExportJobsRequest
  ) extends zio.aws.robomaker.model.ListWorldExportJobsRequest.ReadOnly {
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.robomaker.model.primitives.PaginationToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.robomaker.model.primitives.MaxResults(value))
    override val filters
        : Option[List[zio.aws.robomaker.model.Filter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.Filter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.ListWorldExportJobsRequest
  ): zio.aws.robomaker.model.ListWorldExportJobsRequest.ReadOnly = new Wrapper(
    impl
  )
}
