package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.GenericString
import scala.jdk.CollectionConverters.*
final case class NetworkInterface(
    networkInterfaceId: Option[GenericString] = None,
    privateIpAddress: Option[GenericString] = None,
    publicIpAddress: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.NetworkInterface = {
    import NetworkInterface.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.NetworkInterface
      .builder()
      .optionallyWith(
        networkInterfaceId.map(value =>
          GenericString.unwrap(value): java.lang.String
        )
      )(_.networkInterfaceId)
      .optionallyWith(
        privateIpAddress.map(value =>
          GenericString.unwrap(value): java.lang.String
        )
      )(_.privateIpAddress)
      .optionallyWith(
        publicIpAddress.map(value =>
          GenericString.unwrap(value): java.lang.String
        )
      )(_.publicIpAddress)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.NetworkInterface.ReadOnly =
    zio.aws.robomaker.model.NetworkInterface.wrap(buildAwsValue())
}
object NetworkInterface {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.NetworkInterface
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.NetworkInterface =
      zio.aws.robomaker.model.NetworkInterface(
        networkInterfaceId.map(value => value),
        privateIpAddress.map(value => value),
        publicIpAddress.map(value => value)
      )
    def networkInterfaceId: Option[GenericString]
    def privateIpAddress: Option[GenericString]
    def publicIpAddress: Option[GenericString]
    def getNetworkInterfaceId: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getPrivateIpAddress: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddress)
    def getPublicIpAddress: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("publicIpAddress", publicIpAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.NetworkInterface
  ) extends zio.aws.robomaker.model.NetworkInterface.ReadOnly {
    override val networkInterfaceId: Option[GenericString] = scala
      .Option(impl.networkInterfaceId())
      .map(value => zio.aws.robomaker.model.primitives.GenericString(value))
    override val privateIpAddress: Option[GenericString] = scala
      .Option(impl.privateIpAddress())
      .map(value => zio.aws.robomaker.model.primitives.GenericString(value))
    override val publicIpAddress: Option[GenericString] = scala
      .Option(impl.publicIpAddress())
      .map(value => zio.aws.robomaker.model.primitives.GenericString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.NetworkInterface
  ): zio.aws.robomaker.model.NetworkInterface.ReadOnly = new Wrapper(impl)
}
