package zio.aws.robomaker.model
import scala.jdk.CollectionConverters.*
sealed trait RenderingEngineType {
  def unwrap
      : software.amazon.awssdk.services.robomaker.model.RenderingEngineType
}
object RenderingEngineType {
  def wrap(
      value: software.amazon.awssdk.services.robomaker.model.RenderingEngineType
  ): zio.aws.robomaker.model.RenderingEngineType = value match {
    case software.amazon.awssdk.services.robomaker.model.RenderingEngineType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.robomaker.model.RenderingEngineType.OGRE =>
      val r = OGRE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.robomaker.model.RenderingEngineType {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.RenderingEngineType =
      software.amazon.awssdk.services.robomaker.model.RenderingEngineType.UNKNOWN_TO_SDK_VERSION
  }
  case object OGRE extends zio.aws.robomaker.model.RenderingEngineType {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.RenderingEngineType =
      software.amazon.awssdk.services.robomaker.model.RenderingEngineType.OGRE
  }
}
