package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.robomaker.model.primitives.{LastUpdatedAt, Version, Arn, Name}
import scala.jdk.CollectionConverters.*
final case class RobotApplicationSummary(
    name: Option[Name] = None,
    arn: Option[Arn] = None,
    version: Option[Version] = None,
    lastUpdatedAt: Option[LastUpdatedAt] = None,
    robotSoftwareSuite: Option[zio.aws.robomaker.model.RobotSoftwareSuite] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.RobotApplicationSummary = {
    import RobotApplicationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.RobotApplicationSummary
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        version.map(value => Version.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(
        lastUpdatedAt.map(value => LastUpdatedAt.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(robotSoftwareSuite.map(value => value.buildAwsValue()))(
        _.robotSoftwareSuite
      )
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.RobotApplicationSummary.ReadOnly =
    zio.aws.robomaker.model.RobotApplicationSummary.wrap(buildAwsValue())
}
object RobotApplicationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.RobotApplicationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.RobotApplicationSummary =
      zio.aws.robomaker.model.RobotApplicationSummary(
        name.map(value => value),
        arn.map(value => value),
        version.map(value => value),
        lastUpdatedAt.map(value => value),
        robotSoftwareSuite.map(value => value.asEditable)
      )
    def name: Option[Name]
    def arn: Option[Arn]
    def version: Option[Version]
    def lastUpdatedAt: Option[LastUpdatedAt]
    def robotSoftwareSuite
        : Option[zio.aws.robomaker.model.RobotSoftwareSuite.ReadOnly]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("version", version)
    def getLastUpdatedAt: ZIO[Any, AwsError, LastUpdatedAt] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getRobotSoftwareSuite: ZIO[
      Any,
      AwsError,
      zio.aws.robomaker.model.RobotSoftwareSuite.ReadOnly
    ] = AwsError.unwrapOptionField("robotSoftwareSuite", robotSoftwareSuite)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.RobotApplicationSummary
  ) extends zio.aws.robomaker.model.RobotApplicationSummary.ReadOnly {
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.robomaker.model.primitives.Name(value))
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val version: Option[Version] = scala
      .Option(impl.version())
      .map(value => zio.aws.robomaker.model.primitives.Version(value))
    override val lastUpdatedAt: Option[LastUpdatedAt] = scala
      .Option(impl.lastUpdatedAt())
      .map(value => zio.aws.robomaker.model.primitives.LastUpdatedAt(value))
    override val robotSoftwareSuite
        : Option[zio.aws.robomaker.model.RobotSoftwareSuite.ReadOnly] = scala
      .Option(impl.robotSoftwareSuite())
      .map(value => zio.aws.robomaker.model.RobotSoftwareSuite.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.RobotApplicationSummary
  ): zio.aws.robomaker.model.RobotApplicationSummary.ReadOnly = new Wrapper(
    impl
  )
}
