package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.{S3Etag, S3Key, S3Bucket}
import scala.jdk.CollectionConverters.*
final case class S3Object(
    bucket: S3Bucket,
    key: S3Key,
    etag: Option[S3Etag] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.S3Object = {
    import S3Object.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.S3Object
      .builder()
      .bucket(S3Bucket.unwrap(bucket): java.lang.String)
      .key(S3Key.unwrap(key): java.lang.String)
      .optionallyWith(
        etag.map(value => S3Etag.unwrap(value): java.lang.String)
      )(_.etag)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.S3Object.ReadOnly =
    zio.aws.robomaker.model.S3Object.wrap(buildAwsValue())
}
object S3Object {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.S3Object
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.S3Object =
      zio.aws.robomaker.model.S3Object(bucket, key, etag.map(value => value))
    def bucket: S3Bucket
    def key: S3Key
    def etag: Option[S3Etag]
    def getBucket: ZIO[Any, Nothing, S3Bucket] = ZIO.succeed(bucket)
    def getKey: ZIO[Any, Nothing, S3Key] = ZIO.succeed(key)
    def getEtag: ZIO[Any, AwsError, S3Etag] =
      AwsError.unwrapOptionField("etag", etag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.S3Object
  ) extends zio.aws.robomaker.model.S3Object.ReadOnly {
    override val bucket: S3Bucket =
      zio.aws.robomaker.model.primitives.S3Bucket(impl.bucket())
    override val key: S3Key =
      zio.aws.robomaker.model.primitives.S3Key(impl.key())
    override val etag: Option[S3Etag] = scala
      .Option(impl.etag())
      .map(value => zio.aws.robomaker.model.primitives.S3Etag(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.S3Object
  ): zio.aws.robomaker.model.S3Object.ReadOnly = new Wrapper(impl)
}
