package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.{
  IamRole,
  TagValue,
  JobDuration,
  BoxedBoolean,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class SimulationJobRequest(
    outputLocation: Option[zio.aws.robomaker.model.OutputLocation] = None,
    loggingConfig: Option[zio.aws.robomaker.model.LoggingConfig] = None,
    maxJobDurationInSeconds: JobDuration,
    iamRole: Option[IamRole] = None,
    failureBehavior: Option[zio.aws.robomaker.model.FailureBehavior] = None,
    useDefaultApplications: Option[BoxedBoolean] = None,
    robotApplications: Option[
      Iterable[zio.aws.robomaker.model.RobotApplicationConfig]
    ] = None,
    simulationApplications: Option[
      Iterable[zio.aws.robomaker.model.SimulationApplicationConfig]
    ] = None,
    dataSources: Option[Iterable[zio.aws.robomaker.model.DataSourceConfig]] =
      None,
    vpcConfig: Option[zio.aws.robomaker.model.VPCConfig] = None,
    compute: Option[zio.aws.robomaker.model.Compute] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.SimulationJobRequest = {
    import SimulationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.SimulationJobRequest
      .builder()
      .optionallyWith(outputLocation.map(value => value.buildAwsValue()))(
        _.outputLocation
      )
      .optionallyWith(loggingConfig.map(value => value.buildAwsValue()))(
        _.loggingConfig
      )
      .maxJobDurationInSeconds(
        JobDuration.unwrap(maxJobDurationInSeconds): java.lang.Long
      )
      .optionallyWith(
        iamRole.map(value => IamRole.unwrap(value): java.lang.String)
      )(_.iamRole)
      .optionallyWith(failureBehavior.map(value => value.unwrap))(
        _.failureBehavior
      )
      .optionallyWith(
        useDefaultApplications.map(value =>
          BoxedBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.useDefaultApplications)
      .optionallyWith(
        robotApplications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.robotApplications)
      .optionallyWith(
        simulationApplications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.simulationApplications)
      .optionallyWith(
        dataSources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataSources)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(compute.map(value => value.buildAwsValue()))(_.compute)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.SimulationJobRequest.ReadOnly =
    zio.aws.robomaker.model.SimulationJobRequest.wrap(buildAwsValue())
}
object SimulationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.SimulationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.SimulationJobRequest =
      zio.aws.robomaker.model.SimulationJobRequest(
        outputLocation.map(value => value.asEditable),
        loggingConfig.map(value => value.asEditable),
        maxJobDurationInSeconds,
        iamRole.map(value => value),
        failureBehavior.map(value => value),
        useDefaultApplications.map(value => value),
        robotApplications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        simulationApplications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dataSources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcConfig.map(value => value.asEditable),
        compute.map(value => value.asEditable),
        tags.map(value => value)
      )
    def outputLocation: Option[zio.aws.robomaker.model.OutputLocation.ReadOnly]
    def loggingConfig: Option[zio.aws.robomaker.model.LoggingConfig.ReadOnly]
    def maxJobDurationInSeconds: JobDuration
    def iamRole: Option[IamRole]
    def failureBehavior: Option[zio.aws.robomaker.model.FailureBehavior]
    def useDefaultApplications: Option[BoxedBoolean]
    def robotApplications
        : Option[List[zio.aws.robomaker.model.RobotApplicationConfig.ReadOnly]]
    def simulationApplications: Option[
      List[zio.aws.robomaker.model.SimulationApplicationConfig.ReadOnly]
    ]
    def dataSources
        : Option[List[zio.aws.robomaker.model.DataSourceConfig.ReadOnly]]
    def vpcConfig: Option[zio.aws.robomaker.model.VPCConfig.ReadOnly]
    def compute: Option[zio.aws.robomaker.model.Compute.ReadOnly]
    def tags: Option[Map[TagKey, TagValue]]
    def getOutputLocation
        : ZIO[Any, AwsError, zio.aws.robomaker.model.OutputLocation.ReadOnly] =
      AwsError.unwrapOptionField("outputLocation", outputLocation)
    def getLoggingConfig
        : ZIO[Any, AwsError, zio.aws.robomaker.model.LoggingConfig.ReadOnly] =
      AwsError.unwrapOptionField("loggingConfig", loggingConfig)
    def getMaxJobDurationInSeconds: ZIO[Any, Nothing, JobDuration] =
      ZIO.succeed(maxJobDurationInSeconds)
    def getIamRole: ZIO[Any, AwsError, IamRole] =
      AwsError.unwrapOptionField("iamRole", iamRole)
    def getFailureBehavior
        : ZIO[Any, AwsError, zio.aws.robomaker.model.FailureBehavior] =
      AwsError.unwrapOptionField("failureBehavior", failureBehavior)
    def getUseDefaultApplications: ZIO[Any, AwsError, BoxedBoolean] = AwsError
      .unwrapOptionField("useDefaultApplications", useDefaultApplications)
    def getRobotApplications: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.RobotApplicationConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("robotApplications", robotApplications)
    def getSimulationApplications: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.SimulationApplicationConfig.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "simulationApplications",
      simulationApplications
    )
    def getDataSources: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.DataSourceConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("dataSources", dataSources)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.robomaker.model.VPCConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getCompute
        : ZIO[Any, AwsError, zio.aws.robomaker.model.Compute.ReadOnly] =
      AwsError.unwrapOptionField("compute", compute)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.SimulationJobRequest
  ) extends zio.aws.robomaker.model.SimulationJobRequest.ReadOnly {
    override val outputLocation
        : Option[zio.aws.robomaker.model.OutputLocation.ReadOnly] = scala
      .Option(impl.outputLocation())
      .map(value => zio.aws.robomaker.model.OutputLocation.wrap(value))
    override val loggingConfig
        : Option[zio.aws.robomaker.model.LoggingConfig.ReadOnly] = scala
      .Option(impl.loggingConfig())
      .map(value => zio.aws.robomaker.model.LoggingConfig.wrap(value))
    override val maxJobDurationInSeconds: JobDuration =
      zio.aws.robomaker.model.primitives
        .JobDuration(impl.maxJobDurationInSeconds())
    override val iamRole: Option[IamRole] = scala
      .Option(impl.iamRole())
      .map(value => zio.aws.robomaker.model.primitives.IamRole(value))
    override val failureBehavior
        : Option[zio.aws.robomaker.model.FailureBehavior] = scala
      .Option(impl.failureBehavior())
      .map(value => zio.aws.robomaker.model.FailureBehavior.wrap(value))
    override val useDefaultApplications: Option[BoxedBoolean] = scala
      .Option(impl.useDefaultApplications())
      .map(value => zio.aws.robomaker.model.primitives.BoxedBoolean(value))
    override val robotApplications: Option[
      List[zio.aws.robomaker.model.RobotApplicationConfig.ReadOnly]
    ] = scala
      .Option(impl.robotApplications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.RobotApplicationConfig.wrap(item)
        }.toList
      )
    override val simulationApplications: Option[
      List[zio.aws.robomaker.model.SimulationApplicationConfig.ReadOnly]
    ] = scala
      .Option(impl.simulationApplications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.SimulationApplicationConfig.wrap(item)
        }.toList
      )
    override val dataSources
        : Option[List[zio.aws.robomaker.model.DataSourceConfig.ReadOnly]] =
      scala
        .Option(impl.dataSources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.robomaker.model.DataSourceConfig.wrap(item)
          }.toList
        )
    override val vpcConfig: Option[zio.aws.robomaker.model.VPCConfig.ReadOnly] =
      scala
        .Option(impl.vpcConfig())
        .map(value => zio.aws.robomaker.model.VPCConfig.wrap(value))
    override val compute: Option[zio.aws.robomaker.model.Compute.ReadOnly] =
      scala
        .Option(impl.compute())
        .map(value => zio.aws.robomaker.model.Compute.wrap(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.robomaker.model.primitives
              .TagKey(key) -> zio.aws.robomaker.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.SimulationJobRequest
  ): zio.aws.robomaker.model.SimulationJobRequest.ReadOnly = new Wrapper(impl)
}
