package zio.aws.robomaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.{
  InteriorCountPerFloorplan,
  FloorplanCount
}
import scala.jdk.CollectionConverters.*
final case class WorldCount(
    floorplanCount: Option[FloorplanCount] = None,
    interiorCountPerFloorplan: Option[InteriorCountPerFloorplan] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.WorldCount = {
    import WorldCount.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.WorldCount
      .builder()
      .optionallyWith(
        floorplanCount.map(value => FloorplanCount.unwrap(value): Integer)
      )(_.floorplanCount)
      .optionallyWith(
        interiorCountPerFloorplan.map(value =>
          InteriorCountPerFloorplan.unwrap(value): Integer
        )
      )(_.interiorCountPerFloorplan)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.WorldCount.ReadOnly =
    zio.aws.robomaker.model.WorldCount.wrap(buildAwsValue())
}
object WorldCount {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.WorldCount
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.WorldCount =
      zio.aws.robomaker.model.WorldCount(
        floorplanCount.map(value => value),
        interiorCountPerFloorplan.map(value => value)
      )
    def floorplanCount: Option[FloorplanCount]
    def interiorCountPerFloorplan: Option[InteriorCountPerFloorplan]
    def getFloorplanCount: ZIO[Any, AwsError, FloorplanCount] =
      AwsError.unwrapOptionField("floorplanCount", floorplanCount)
    def getInteriorCountPerFloorplan
        : ZIO[Any, AwsError, InteriorCountPerFloorplan] = AwsError
      .unwrapOptionField("interiorCountPerFloorplan", interiorCountPerFloorplan)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.WorldCount
  ) extends zio.aws.robomaker.model.WorldCount.ReadOnly {
    override val floorplanCount: Option[FloorplanCount] = scala
      .Option(impl.floorplanCount())
      .map(value => zio.aws.robomaker.model.primitives.FloorplanCount(value))
    override val interiorCountPerFloorplan: Option[InteriorCountPerFloorplan] =
      scala
        .Option(impl.interiorCountPerFloorplan())
        .map(value =>
          zio.aws.robomaker.model.primitives.InteriorCountPerFloorplan(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.WorldCount
  ): zio.aws.robomaker.model.WorldCount.ReadOnly = new Wrapper(impl)
}
