package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.robomaker.model.primitives.{Integer, CreatedAt, Arn}
import scala.jdk.CollectionConverters.*
final case class WorldGenerationJobSummary(
    arn: Option[Arn] = None,
    template: Option[Arn] = None,
    createdAt: Option[CreatedAt] = None,
    status: Option[zio.aws.robomaker.model.WorldGenerationJobStatus] = None,
    worldCount: Option[zio.aws.robomaker.model.WorldCount] = None,
    succeededWorldCount: Option[Integer] = None,
    failedWorldCount: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.WorldGenerationJobSummary = {
    import WorldGenerationJobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.WorldGenerationJobSummary
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        template.map(value => Arn.unwrap(value): java.lang.String)
      )(_.template)
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(worldCount.map(value => value.buildAwsValue()))(
        _.worldCount
      )
      .optionallyWith(
        succeededWorldCount.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.succeededWorldCount)
      .optionallyWith(
        failedWorldCount.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.failedWorldCount)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.WorldGenerationJobSummary.ReadOnly =
    zio.aws.robomaker.model.WorldGenerationJobSummary.wrap(buildAwsValue())
}
object WorldGenerationJobSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.WorldGenerationJobSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.WorldGenerationJobSummary =
      zio.aws.robomaker.model.WorldGenerationJobSummary(
        arn.map(value => value),
        template.map(value => value),
        createdAt.map(value => value),
        status.map(value => value),
        worldCount.map(value => value.asEditable),
        succeededWorldCount.map(value => value),
        failedWorldCount.map(value => value)
      )
    def arn: Option[Arn]
    def template: Option[Arn]
    def createdAt: Option[CreatedAt]
    def status: Option[zio.aws.robomaker.model.WorldGenerationJobStatus]
    def worldCount: Option[zio.aws.robomaker.model.WorldCount.ReadOnly]
    def succeededWorldCount: Option[Integer]
    def failedWorldCount: Option[Integer]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getTemplate: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("template", template)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.robomaker.model.WorldGenerationJobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getWorldCount
        : ZIO[Any, AwsError, zio.aws.robomaker.model.WorldCount.ReadOnly] =
      AwsError.unwrapOptionField("worldCount", worldCount)
    def getSucceededWorldCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("succeededWorldCount", succeededWorldCount)
    def getFailedWorldCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("failedWorldCount", failedWorldCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.WorldGenerationJobSummary
  ) extends zio.aws.robomaker.model.WorldGenerationJobSummary.ReadOnly {
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val template: Option[Arn] = scala
      .Option(impl.template())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val createdAt: Option[CreatedAt] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.robomaker.model.primitives.CreatedAt(value))
    override val status
        : Option[zio.aws.robomaker.model.WorldGenerationJobStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.robomaker.model.WorldGenerationJobStatus.wrap(value)
      )
    override val worldCount
        : Option[zio.aws.robomaker.model.WorldCount.ReadOnly] = scala
      .Option(impl.worldCount())
      .map(value => zio.aws.robomaker.model.WorldCount.wrap(value))
    override val succeededWorldCount: Option[Integer] = scala
      .Option(impl.succeededWorldCount())
      .map(value => zio.aws.robomaker.model.primitives.Integer(value))
    override val failedWorldCount: Option[Integer] = scala
      .Option(impl.failedWorldCount())
      .map(value => zio.aws.robomaker.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.WorldGenerationJobSummary
  ): zio.aws.robomaker.model.WorldGenerationJobSummary.ReadOnly = new Wrapper(
    impl
  )
}
