package zio.aws.robomaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.{GPUUnit, SimulationUnit}
import scala.jdk.CollectionConverters.*
final case class ComputeResponse(
    simulationUnitLimit: Option[SimulationUnit] = None,
    computeType: Option[zio.aws.robomaker.model.ComputeType] = None,
    gpuUnitLimit: Option[GPUUnit] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.ComputeResponse = {
    import ComputeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.ComputeResponse
      .builder()
      .optionallyWith(
        simulationUnitLimit.map(value => SimulationUnit.unwrap(value): Integer)
      )(_.simulationUnitLimit)
      .optionallyWith(computeType.map(value => value.unwrap))(_.computeType)
      .optionallyWith(
        gpuUnitLimit.map(value => GPUUnit.unwrap(value): Integer)
      )(_.gpuUnitLimit)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.ComputeResponse.ReadOnly =
    zio.aws.robomaker.model.ComputeResponse.wrap(buildAwsValue())
}
object ComputeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.ComputeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.ComputeResponse =
      zio.aws.robomaker.model.ComputeResponse(
        simulationUnitLimit.map(value => value),
        computeType.map(value => value),
        gpuUnitLimit.map(value => value)
      )
    def simulationUnitLimit: Option[SimulationUnit]
    def computeType: Option[zio.aws.robomaker.model.ComputeType]
    def gpuUnitLimit: Option[GPUUnit]
    def getSimulationUnitLimit: ZIO[Any, AwsError, SimulationUnit] =
      AwsError.unwrapOptionField("simulationUnitLimit", simulationUnitLimit)
    def getComputeType
        : ZIO[Any, AwsError, zio.aws.robomaker.model.ComputeType] =
      AwsError.unwrapOptionField("computeType", computeType)
    def getGpuUnitLimit: ZIO[Any, AwsError, GPUUnit] =
      AwsError.unwrapOptionField("gpuUnitLimit", gpuUnitLimit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.ComputeResponse
  ) extends zio.aws.robomaker.model.ComputeResponse.ReadOnly {
    override val simulationUnitLimit: Option[SimulationUnit] = scala
      .Option(impl.simulationUnitLimit())
      .map(value => zio.aws.robomaker.model.primitives.SimulationUnit(value))
    override val computeType: Option[zio.aws.robomaker.model.ComputeType] =
      scala
        .Option(impl.computeType())
        .map(value => zio.aws.robomaker.model.ComputeType.wrap(value))
    override val gpuUnitLimit: Option[GPUUnit] = scala
      .Option(impl.gpuUnitLimit())
      .map(value => zio.aws.robomaker.model.primitives.GPUUnit(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.ComputeResponse
  ): zio.aws.robomaker.model.ComputeResponse.ReadOnly = new Wrapper(impl)
}
