package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.{TagValue, TagKey, Name}
import scala.jdk.CollectionConverters.*
final case class CreateRobotApplicationRequest(
    name: Name,
    sources: Option[Iterable[zio.aws.robomaker.model.SourceConfig]] = None,
    robotSoftwareSuite: zio.aws.robomaker.model.RobotSoftwareSuite,
    tags: Option[Map[TagKey, TagValue]] = None,
    environment: Option[zio.aws.robomaker.model.Environment] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.CreateRobotApplicationRequest = {
    import CreateRobotApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.CreateRobotApplicationRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        sources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sources)
      .robotSoftwareSuite(robotSoftwareSuite.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(environment.map(value => value.buildAwsValue()))(
        _.environment
      )
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.CreateRobotApplicationRequest.ReadOnly =
    zio.aws.robomaker.model.CreateRobotApplicationRequest.wrap(buildAwsValue())
}
object CreateRobotApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.CreateRobotApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.CreateRobotApplicationRequest =
      zio.aws.robomaker.model.CreateRobotApplicationRequest(
        name,
        sources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        robotSoftwareSuite.asEditable,
        tags.map(value => value),
        environment.map(value => value.asEditable)
      )
    def name: Name
    def sources: Option[List[zio.aws.robomaker.model.SourceConfig.ReadOnly]]
    def robotSoftwareSuite: zio.aws.robomaker.model.RobotSoftwareSuite.ReadOnly
    def tags: Option[Map[TagKey, TagValue]]
    def environment: Option[zio.aws.robomaker.model.Environment.ReadOnly]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getSources: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.SourceConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("sources", sources)
    def getRobotSoftwareSuite: ZIO[
      Any,
      Nothing,
      zio.aws.robomaker.model.RobotSoftwareSuite.ReadOnly
    ] = ZIO.succeed(robotSoftwareSuite)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getEnvironment
        : ZIO[Any, AwsError, zio.aws.robomaker.model.Environment.ReadOnly] =
      AwsError.unwrapOptionField("environment", environment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.CreateRobotApplicationRequest
  ) extends zio.aws.robomaker.model.CreateRobotApplicationRequest.ReadOnly {
    override val name: Name =
      zio.aws.robomaker.model.primitives.Name(impl.name())
    override val sources
        : Option[List[zio.aws.robomaker.model.SourceConfig.ReadOnly]] = scala
      .Option(impl.sources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.SourceConfig.wrap(item)
        }.toList
      )
    override val robotSoftwareSuite
        : zio.aws.robomaker.model.RobotSoftwareSuite.ReadOnly =
      zio.aws.robomaker.model.RobotSoftwareSuite.wrap(impl.robotSoftwareSuite())
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.robomaker.model.primitives
              .TagKey(key) -> zio.aws.robomaker.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val environment
        : Option[zio.aws.robomaker.model.Environment.ReadOnly] = scala
      .Option(impl.environment())
      .map(value => zio.aws.robomaker.model.Environment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.CreateRobotApplicationRequest
  ): zio.aws.robomaker.model.CreateRobotApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
