package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.{
  IamRole,
  ClientRequestToken,
  TagValue,
  JobDuration,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class CreateSimulationJobRequest(
    clientRequestToken: Option[ClientRequestToken] = None,
    outputLocation: Option[zio.aws.robomaker.model.OutputLocation] = None,
    loggingConfig: Option[zio.aws.robomaker.model.LoggingConfig] = None,
    maxJobDurationInSeconds: JobDuration,
    iamRole: IamRole,
    failureBehavior: Option[zio.aws.robomaker.model.FailureBehavior] = None,
    robotApplications: Option[
      Iterable[zio.aws.robomaker.model.RobotApplicationConfig]
    ] = None,
    simulationApplications: Option[
      Iterable[zio.aws.robomaker.model.SimulationApplicationConfig]
    ] = None,
    dataSources: Option[Iterable[zio.aws.robomaker.model.DataSourceConfig]] =
      None,
    tags: Option[Map[TagKey, TagValue]] = None,
    vpcConfig: Option[zio.aws.robomaker.model.VPCConfig] = None,
    compute: Option[zio.aws.robomaker.model.Compute] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.CreateSimulationJobRequest = {
    import CreateSimulationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.CreateSimulationJobRequest
      .builder()
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(outputLocation.map(value => value.buildAwsValue()))(
        _.outputLocation
      )
      .optionallyWith(loggingConfig.map(value => value.buildAwsValue()))(
        _.loggingConfig
      )
      .maxJobDurationInSeconds(
        JobDuration.unwrap(maxJobDurationInSeconds): java.lang.Long
      )
      .iamRole(IamRole.unwrap(iamRole): java.lang.String)
      .optionallyWith(failureBehavior.map(value => value.unwrap))(
        _.failureBehavior
      )
      .optionallyWith(
        robotApplications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.robotApplications)
      .optionallyWith(
        simulationApplications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.simulationApplications)
      .optionallyWith(
        dataSources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataSources)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(compute.map(value => value.buildAwsValue()))(_.compute)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.CreateSimulationJobRequest.ReadOnly =
    zio.aws.robomaker.model.CreateSimulationJobRequest.wrap(buildAwsValue())
}
object CreateSimulationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.CreateSimulationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.CreateSimulationJobRequest =
      zio.aws.robomaker.model.CreateSimulationJobRequest(
        clientRequestToken.map(value => value),
        outputLocation.map(value => value.asEditable),
        loggingConfig.map(value => value.asEditable),
        maxJobDurationInSeconds,
        iamRole,
        failureBehavior.map(value => value),
        robotApplications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        simulationApplications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dataSources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value => value),
        vpcConfig.map(value => value.asEditable),
        compute.map(value => value.asEditable)
      )
    def clientRequestToken: Option[ClientRequestToken]
    def outputLocation: Option[zio.aws.robomaker.model.OutputLocation.ReadOnly]
    def loggingConfig: Option[zio.aws.robomaker.model.LoggingConfig.ReadOnly]
    def maxJobDurationInSeconds: JobDuration
    def iamRole: IamRole
    def failureBehavior: Option[zio.aws.robomaker.model.FailureBehavior]
    def robotApplications
        : Option[List[zio.aws.robomaker.model.RobotApplicationConfig.ReadOnly]]
    def simulationApplications: Option[
      List[zio.aws.robomaker.model.SimulationApplicationConfig.ReadOnly]
    ]
    def dataSources
        : Option[List[zio.aws.robomaker.model.DataSourceConfig.ReadOnly]]
    def tags: Option[Map[TagKey, TagValue]]
    def vpcConfig: Option[zio.aws.robomaker.model.VPCConfig.ReadOnly]
    def compute: Option[zio.aws.robomaker.model.Compute.ReadOnly]
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getOutputLocation
        : ZIO[Any, AwsError, zio.aws.robomaker.model.OutputLocation.ReadOnly] =
      AwsError.unwrapOptionField("outputLocation", outputLocation)
    def getLoggingConfig
        : ZIO[Any, AwsError, zio.aws.robomaker.model.LoggingConfig.ReadOnly] =
      AwsError.unwrapOptionField("loggingConfig", loggingConfig)
    def getMaxJobDurationInSeconds: ZIO[Any, Nothing, JobDuration] =
      ZIO.succeed(maxJobDurationInSeconds)
    def getIamRole: ZIO[Any, Nothing, IamRole] = ZIO.succeed(iamRole)
    def getFailureBehavior
        : ZIO[Any, AwsError, zio.aws.robomaker.model.FailureBehavior] =
      AwsError.unwrapOptionField("failureBehavior", failureBehavior)
    def getRobotApplications: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.RobotApplicationConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("robotApplications", robotApplications)
    def getSimulationApplications: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.SimulationApplicationConfig.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "simulationApplications",
      simulationApplications
    )
    def getDataSources: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.DataSourceConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("dataSources", dataSources)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.robomaker.model.VPCConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getCompute
        : ZIO[Any, AwsError, zio.aws.robomaker.model.Compute.ReadOnly] =
      AwsError.unwrapOptionField("compute", compute)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.CreateSimulationJobRequest
  ) extends zio.aws.robomaker.model.CreateSimulationJobRequest.ReadOnly {
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.robomaker.model.primitives.ClientRequestToken(value)
      )
    override val outputLocation
        : Option[zio.aws.robomaker.model.OutputLocation.ReadOnly] = scala
      .Option(impl.outputLocation())
      .map(value => zio.aws.robomaker.model.OutputLocation.wrap(value))
    override val loggingConfig
        : Option[zio.aws.robomaker.model.LoggingConfig.ReadOnly] = scala
      .Option(impl.loggingConfig())
      .map(value => zio.aws.robomaker.model.LoggingConfig.wrap(value))
    override val maxJobDurationInSeconds: JobDuration =
      zio.aws.robomaker.model.primitives
        .JobDuration(impl.maxJobDurationInSeconds())
    override val iamRole: IamRole =
      zio.aws.robomaker.model.primitives.IamRole(impl.iamRole())
    override val failureBehavior
        : Option[zio.aws.robomaker.model.FailureBehavior] = scala
      .Option(impl.failureBehavior())
      .map(value => zio.aws.robomaker.model.FailureBehavior.wrap(value))
    override val robotApplications: Option[
      List[zio.aws.robomaker.model.RobotApplicationConfig.ReadOnly]
    ] = scala
      .Option(impl.robotApplications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.RobotApplicationConfig.wrap(item)
        }.toList
      )
    override val simulationApplications: Option[
      List[zio.aws.robomaker.model.SimulationApplicationConfig.ReadOnly]
    ] = scala
      .Option(impl.simulationApplications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.SimulationApplicationConfig.wrap(item)
        }.toList
      )
    override val dataSources
        : Option[List[zio.aws.robomaker.model.DataSourceConfig.ReadOnly]] =
      scala
        .Option(impl.dataSources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.robomaker.model.DataSourceConfig.wrap(item)
          }.toList
        )
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.robomaker.model.primitives
              .TagKey(key) -> zio.aws.robomaker.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val vpcConfig: Option[zio.aws.robomaker.model.VPCConfig.ReadOnly] =
      scala
        .Option(impl.vpcConfig())
        .map(value => zio.aws.robomaker.model.VPCConfig.wrap(value))
    override val compute: Option[zio.aws.robomaker.model.Compute.ReadOnly] =
      scala
        .Option(impl.compute())
        .map(value => zio.aws.robomaker.model.Compute.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.CreateSimulationJobRequest
  ): zio.aws.robomaker.model.CreateSimulationJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
