package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.{
  TagValue,
  TagKey,
  Arn,
  ClientRequestToken
}
import scala.jdk.CollectionConverters.*
final case class CreateWorldGenerationJobRequest(
    clientRequestToken: Option[ClientRequestToken] = None,
    template: Arn,
    worldCount: zio.aws.robomaker.model.WorldCount,
    tags: Option[Map[TagKey, TagValue]] = None,
    worldTags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.CreateWorldGenerationJobRequest = {
    import CreateWorldGenerationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.CreateWorldGenerationJobRequest
      .builder()
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .template(Arn.unwrap(template): java.lang.String)
      .worldCount(worldCount.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        worldTags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.worldTags)
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.CreateWorldGenerationJobRequest.ReadOnly =
    zio.aws.robomaker.model.CreateWorldGenerationJobRequest
      .wrap(buildAwsValue())
}
object CreateWorldGenerationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.CreateWorldGenerationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.CreateWorldGenerationJobRequest =
      zio.aws.robomaker.model.CreateWorldGenerationJobRequest(
        clientRequestToken.map(value => value),
        template,
        worldCount.asEditable,
        tags.map(value => value),
        worldTags.map(value => value)
      )
    def clientRequestToken: Option[ClientRequestToken]
    def template: Arn
    def worldCount: zio.aws.robomaker.model.WorldCount.ReadOnly
    def tags: Option[Map[TagKey, TagValue]]
    def worldTags: Option[Map[TagKey, TagValue]]
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getTemplate: ZIO[Any, Nothing, Arn] = ZIO.succeed(template)
    def getWorldCount
        : ZIO[Any, Nothing, zio.aws.robomaker.model.WorldCount.ReadOnly] =
      ZIO.succeed(worldCount)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getWorldTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("worldTags", worldTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.CreateWorldGenerationJobRequest
  ) extends zio.aws.robomaker.model.CreateWorldGenerationJobRequest.ReadOnly {
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.robomaker.model.primitives.ClientRequestToken(value)
      )
    override val template: Arn =
      zio.aws.robomaker.model.primitives.Arn(impl.template())
    override val worldCount: zio.aws.robomaker.model.WorldCount.ReadOnly =
      zio.aws.robomaker.model.WorldCount.wrap(impl.worldCount())
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.robomaker.model.primitives
              .TagKey(key) -> zio.aws.robomaker.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val worldTags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.worldTags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.robomaker.model.primitives
              .TagKey(key) -> zio.aws.robomaker.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.CreateWorldGenerationJobRequest
  ): zio.aws.robomaker.model.CreateWorldGenerationJobRequest.ReadOnly =
    new Wrapper(impl)
}
