package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.{
  EnvironmentVariableValue,
  EnvironmentVariableKey,
  Path,
  Command
}
import scala.jdk.CollectionConverters.*
final case class DeploymentLaunchConfig(
    packageName: Command,
    preLaunchFile: Option[Path] = None,
    launchFile: Command,
    postLaunchFile: Option[Path] = None,
    environmentVariables: Option[
      Map[EnvironmentVariableKey, EnvironmentVariableValue]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.DeploymentLaunchConfig = {
    import DeploymentLaunchConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.DeploymentLaunchConfig
      .builder()
      .packageName(Command.unwrap(packageName): java.lang.String)
      .optionallyWith(
        preLaunchFile.map(value => Path.unwrap(value): java.lang.String)
      )(_.preLaunchFile)
      .launchFile(Command.unwrap(launchFile): java.lang.String)
      .optionallyWith(
        postLaunchFile.map(value => Path.unwrap(value): java.lang.String)
      )(_.postLaunchFile)
      .optionallyWith(
        environmentVariables.map(value =>
          value
            .map({ case (key, value) =>
              (EnvironmentVariableKey
                .unwrap(key): java.lang.String) -> (EnvironmentVariableValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.environmentVariables)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.DeploymentLaunchConfig.ReadOnly =
    zio.aws.robomaker.model.DeploymentLaunchConfig.wrap(buildAwsValue())
}
object DeploymentLaunchConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.DeploymentLaunchConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.DeploymentLaunchConfig =
      zio.aws.robomaker.model.DeploymentLaunchConfig(
        packageName,
        preLaunchFile.map(value => value),
        launchFile,
        postLaunchFile.map(value => value),
        environmentVariables.map(value => value)
      )
    def packageName: Command
    def preLaunchFile: Option[Path]
    def launchFile: Command
    def postLaunchFile: Option[Path]
    def environmentVariables
        : Option[Map[EnvironmentVariableKey, EnvironmentVariableValue]]
    def getPackageName: ZIO[Any, Nothing, Command] = ZIO.succeed(packageName)
    def getPreLaunchFile: ZIO[Any, AwsError, Path] =
      AwsError.unwrapOptionField("preLaunchFile", preLaunchFile)
    def getLaunchFile: ZIO[Any, Nothing, Command] = ZIO.succeed(launchFile)
    def getPostLaunchFile: ZIO[Any, AwsError, Path] =
      AwsError.unwrapOptionField("postLaunchFile", postLaunchFile)
    def getEnvironmentVariables: ZIO[Any, AwsError, Map[
      EnvironmentVariableKey,
      EnvironmentVariableValue
    ]] =
      AwsError.unwrapOptionField("environmentVariables", environmentVariables)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.DeploymentLaunchConfig
  ) extends zio.aws.robomaker.model.DeploymentLaunchConfig.ReadOnly {
    override val packageName: Command =
      zio.aws.robomaker.model.primitives.Command(impl.packageName())
    override val preLaunchFile: Option[Path] = scala
      .Option(impl.preLaunchFile())
      .map(value => zio.aws.robomaker.model.primitives.Path(value))
    override val launchFile: Command =
      zio.aws.robomaker.model.primitives.Command(impl.launchFile())
    override val postLaunchFile: Option[Path] = scala
      .Option(impl.postLaunchFile())
      .map(value => zio.aws.robomaker.model.primitives.Path(value))
    override val environmentVariables
        : Option[Map[EnvironmentVariableKey, EnvironmentVariableValue]] = scala
      .Option(impl.environmentVariables())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.robomaker.model.primitives
              .EnvironmentVariableKey(key) -> zio.aws.robomaker.model.primitives
              .EnvironmentVariableValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.DeploymentLaunchConfig
  ): zio.aws.robomaker.model.DeploymentLaunchConfig.ReadOnly = new Wrapper(impl)
}
