package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.robomaker.model.primitives.{
  IamRole,
  GenericString,
  ClientRequestToken,
  TagValue,
  SimulationTimeMillis,
  LastStartedAt,
  Arn,
  JobDuration,
  Name,
  LastUpdatedAt,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class DescribeSimulationJobResponse(
    arn: Option[Arn] = None,
    name: Option[Name] = None,
    status: Option[zio.aws.robomaker.model.SimulationJobStatus] = None,
    lastStartedAt: Option[LastStartedAt] = None,
    lastUpdatedAt: Option[LastUpdatedAt] = None,
    failureBehavior: Option[zio.aws.robomaker.model.FailureBehavior] = None,
    failureCode: Option[zio.aws.robomaker.model.SimulationJobErrorCode] = None,
    failureReason: Option[GenericString] = None,
    clientRequestToken: Option[ClientRequestToken] = None,
    outputLocation: Option[zio.aws.robomaker.model.OutputLocation] = None,
    loggingConfig: Option[zio.aws.robomaker.model.LoggingConfig] = None,
    maxJobDurationInSeconds: Option[JobDuration] = None,
    simulationTimeMillis: Option[SimulationTimeMillis] = None,
    iamRole: Option[IamRole] = None,
    robotApplications: Option[
      Iterable[zio.aws.robomaker.model.RobotApplicationConfig]
    ] = None,
    simulationApplications: Option[
      Iterable[zio.aws.robomaker.model.SimulationApplicationConfig]
    ] = None,
    dataSources: Option[Iterable[zio.aws.robomaker.model.DataSource]] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    vpcConfig: Option[zio.aws.robomaker.model.VPCConfigResponse] = None,
    networkInterface: Option[zio.aws.robomaker.model.NetworkInterface] = None,
    compute: Option[zio.aws.robomaker.model.ComputeResponse] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobResponse = {
    import DescribeSimulationJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobResponse
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        lastStartedAt.map(value => LastStartedAt.unwrap(value): Instant)
      )(_.lastStartedAt)
      .optionallyWith(
        lastUpdatedAt.map(value => LastUpdatedAt.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(failureBehavior.map(value => value.unwrap))(
        _.failureBehavior
      )
      .optionallyWith(failureCode.map(value => value.unwrap))(_.failureCode)
      .optionallyWith(failureReason.map(value => value: java.lang.String))(
        _.failureReason
      )
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(outputLocation.map(value => value.buildAwsValue()))(
        _.outputLocation
      )
      .optionallyWith(loggingConfig.map(value => value.buildAwsValue()))(
        _.loggingConfig
      )
      .optionallyWith(
        maxJobDurationInSeconds.map(value =>
          JobDuration.unwrap(value): java.lang.Long
        )
      )(_.maxJobDurationInSeconds)
      .optionallyWith(
        simulationTimeMillis.map(value =>
          SimulationTimeMillis.unwrap(value): java.lang.Long
        )
      )(_.simulationTimeMillis)
      .optionallyWith(
        iamRole.map(value => IamRole.unwrap(value): java.lang.String)
      )(_.iamRole)
      .optionallyWith(
        robotApplications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.robotApplications)
      .optionallyWith(
        simulationApplications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.simulationApplications)
      .optionallyWith(
        dataSources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataSources)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(networkInterface.map(value => value.buildAwsValue()))(
        _.networkInterface
      )
      .optionallyWith(compute.map(value => value.buildAwsValue()))(_.compute)
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.DescribeSimulationJobResponse.ReadOnly =
    zio.aws.robomaker.model.DescribeSimulationJobResponse.wrap(buildAwsValue())
}
object DescribeSimulationJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.DescribeSimulationJobResponse =
      zio.aws.robomaker.model.DescribeSimulationJobResponse(
        arn.map(value => value),
        name.map(value => value),
        status.map(value => value),
        lastStartedAt.map(value => value),
        lastUpdatedAt.map(value => value),
        failureBehavior.map(value => value),
        failureCode.map(value => value),
        failureReason.map(value => value),
        clientRequestToken.map(value => value),
        outputLocation.map(value => value.asEditable),
        loggingConfig.map(value => value.asEditable),
        maxJobDurationInSeconds.map(value => value),
        simulationTimeMillis.map(value => value),
        iamRole.map(value => value),
        robotApplications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        simulationApplications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dataSources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value => value),
        vpcConfig.map(value => value.asEditable),
        networkInterface.map(value => value.asEditable),
        compute.map(value => value.asEditable)
      )
    def arn: Option[Arn]
    def name: Option[Name]
    def status: Option[zio.aws.robomaker.model.SimulationJobStatus]
    def lastStartedAt: Option[LastStartedAt]
    def lastUpdatedAt: Option[LastUpdatedAt]
    def failureBehavior: Option[zio.aws.robomaker.model.FailureBehavior]
    def failureCode: Option[zio.aws.robomaker.model.SimulationJobErrorCode]
    def failureReason: Option[GenericString]
    def clientRequestToken: Option[ClientRequestToken]
    def outputLocation: Option[zio.aws.robomaker.model.OutputLocation.ReadOnly]
    def loggingConfig: Option[zio.aws.robomaker.model.LoggingConfig.ReadOnly]
    def maxJobDurationInSeconds: Option[JobDuration]
    def simulationTimeMillis: Option[SimulationTimeMillis]
    def iamRole: Option[IamRole]
    def robotApplications
        : Option[List[zio.aws.robomaker.model.RobotApplicationConfig.ReadOnly]]
    def simulationApplications: Option[
      List[zio.aws.robomaker.model.SimulationApplicationConfig.ReadOnly]
    ]
    def dataSources: Option[List[zio.aws.robomaker.model.DataSource.ReadOnly]]
    def tags: Option[Map[TagKey, TagValue]]
    def vpcConfig: Option[zio.aws.robomaker.model.VPCConfigResponse.ReadOnly]
    def networkInterface
        : Option[zio.aws.robomaker.model.NetworkInterface.ReadOnly]
    def compute: Option[zio.aws.robomaker.model.ComputeResponse.ReadOnly]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.robomaker.model.SimulationJobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getLastStartedAt: ZIO[Any, AwsError, LastStartedAt] =
      AwsError.unwrapOptionField("lastStartedAt", lastStartedAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, LastUpdatedAt] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getFailureBehavior
        : ZIO[Any, AwsError, zio.aws.robomaker.model.FailureBehavior] =
      AwsError.unwrapOptionField("failureBehavior", failureBehavior)
    def getFailureCode
        : ZIO[Any, AwsError, zio.aws.robomaker.model.SimulationJobErrorCode] =
      AwsError.unwrapOptionField("failureCode", failureCode)
    def getFailureReason: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getOutputLocation
        : ZIO[Any, AwsError, zio.aws.robomaker.model.OutputLocation.ReadOnly] =
      AwsError.unwrapOptionField("outputLocation", outputLocation)
    def getLoggingConfig
        : ZIO[Any, AwsError, zio.aws.robomaker.model.LoggingConfig.ReadOnly] =
      AwsError.unwrapOptionField("loggingConfig", loggingConfig)
    def getMaxJobDurationInSeconds: ZIO[Any, AwsError, JobDuration] = AwsError
      .unwrapOptionField("maxJobDurationInSeconds", maxJobDurationInSeconds)
    def getSimulationTimeMillis: ZIO[Any, AwsError, SimulationTimeMillis] =
      AwsError.unwrapOptionField("simulationTimeMillis", simulationTimeMillis)
    def getIamRole: ZIO[Any, AwsError, IamRole] =
      AwsError.unwrapOptionField("iamRole", iamRole)
    def getRobotApplications: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.RobotApplicationConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("robotApplications", robotApplications)
    def getSimulationApplications: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.SimulationApplicationConfig.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "simulationApplications",
      simulationApplications
    )
    def getDataSources: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.DataSource.ReadOnly
    ]] = AwsError.unwrapOptionField("dataSources", dataSources)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVpcConfig: ZIO[
      Any,
      AwsError,
      zio.aws.robomaker.model.VPCConfigResponse.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getNetworkInterface: ZIO[
      Any,
      AwsError,
      zio.aws.robomaker.model.NetworkInterface.ReadOnly
    ] = AwsError.unwrapOptionField("networkInterface", networkInterface)
    def getCompute
        : ZIO[Any, AwsError, zio.aws.robomaker.model.ComputeResponse.ReadOnly] =
      AwsError.unwrapOptionField("compute", compute)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobResponse
  ) extends zio.aws.robomaker.model.DescribeSimulationJobResponse.ReadOnly {
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.robomaker.model.primitives.Name(value))
    override val status: Option[zio.aws.robomaker.model.SimulationJobStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.robomaker.model.SimulationJobStatus.wrap(value))
    override val lastStartedAt: Option[LastStartedAt] = scala
      .Option(impl.lastStartedAt())
      .map(value => zio.aws.robomaker.model.primitives.LastStartedAt(value))
    override val lastUpdatedAt: Option[LastUpdatedAt] = scala
      .Option(impl.lastUpdatedAt())
      .map(value => zio.aws.robomaker.model.primitives.LastUpdatedAt(value))
    override val failureBehavior
        : Option[zio.aws.robomaker.model.FailureBehavior] = scala
      .Option(impl.failureBehavior())
      .map(value => zio.aws.robomaker.model.FailureBehavior.wrap(value))
    override val failureCode
        : Option[zio.aws.robomaker.model.SimulationJobErrorCode] = scala
      .Option(impl.failureCode())
      .map(value => zio.aws.robomaker.model.SimulationJobErrorCode.wrap(value))
    override val failureReason: Option[GenericString] =
      scala.Option(impl.failureReason()).map(value => value: GenericString)
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.robomaker.model.primitives.ClientRequestToken(value)
      )
    override val outputLocation
        : Option[zio.aws.robomaker.model.OutputLocation.ReadOnly] = scala
      .Option(impl.outputLocation())
      .map(value => zio.aws.robomaker.model.OutputLocation.wrap(value))
    override val loggingConfig
        : Option[zio.aws.robomaker.model.LoggingConfig.ReadOnly] = scala
      .Option(impl.loggingConfig())
      .map(value => zio.aws.robomaker.model.LoggingConfig.wrap(value))
    override val maxJobDurationInSeconds: Option[JobDuration] = scala
      .Option(impl.maxJobDurationInSeconds())
      .map(value => zio.aws.robomaker.model.primitives.JobDuration(value))
    override val simulationTimeMillis: Option[SimulationTimeMillis] = scala
      .Option(impl.simulationTimeMillis())
      .map(value =>
        zio.aws.robomaker.model.primitives.SimulationTimeMillis(value)
      )
    override val iamRole: Option[IamRole] = scala
      .Option(impl.iamRole())
      .map(value => zio.aws.robomaker.model.primitives.IamRole(value))
    override val robotApplications: Option[
      List[zio.aws.robomaker.model.RobotApplicationConfig.ReadOnly]
    ] = scala
      .Option(impl.robotApplications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.RobotApplicationConfig.wrap(item)
        }.toList
      )
    override val simulationApplications: Option[
      List[zio.aws.robomaker.model.SimulationApplicationConfig.ReadOnly]
    ] = scala
      .Option(impl.simulationApplications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.SimulationApplicationConfig.wrap(item)
        }.toList
      )
    override val dataSources
        : Option[List[zio.aws.robomaker.model.DataSource.ReadOnly]] = scala
      .Option(impl.dataSources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.DataSource.wrap(item)
        }.toList
      )
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.robomaker.model.primitives
              .TagKey(key) -> zio.aws.robomaker.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val vpcConfig
        : Option[zio.aws.robomaker.model.VPCConfigResponse.ReadOnly] = scala
      .Option(impl.vpcConfig())
      .map(value => zio.aws.robomaker.model.VPCConfigResponse.wrap(value))
    override val networkInterface
        : Option[zio.aws.robomaker.model.NetworkInterface.ReadOnly] = scala
      .Option(impl.networkInterface())
      .map(value => zio.aws.robomaker.model.NetworkInterface.wrap(value))
    override val compute
        : Option[zio.aws.robomaker.model.ComputeResponse.ReadOnly] = scala
      .Option(impl.compute())
      .map(value => zio.aws.robomaker.model.ComputeResponse.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobResponse
  ): zio.aws.robomaker.model.DescribeSimulationJobResponse.ReadOnly =
    new Wrapper(impl)
}
