package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.robomaker.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class DescribeWorldExportJobRequest(job: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.DescribeWorldExportJobRequest = {
    import DescribeWorldExportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.DescribeWorldExportJobRequest
      .builder()
      .job(Arn.unwrap(job): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.DescribeWorldExportJobRequest.ReadOnly =
    zio.aws.robomaker.model.DescribeWorldExportJobRequest.wrap(buildAwsValue())
}
object DescribeWorldExportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.DescribeWorldExportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.DescribeWorldExportJobRequest =
      zio.aws.robomaker.model.DescribeWorldExportJobRequest(job)
    def job: Arn
    def getJob: ZIO[Any, Nothing, Arn] = ZIO.succeed(job)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeWorldExportJobRequest
  ) extends zio.aws.robomaker.model.DescribeWorldExportJobRequest.ReadOnly {
    override val job: Arn = zio.aws.robomaker.model.primitives.Arn(impl.job())
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeWorldExportJobRequest
  ): zio.aws.robomaker.model.DescribeWorldExportJobRequest.ReadOnly =
    new Wrapper(impl)
}
