package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class FailureSummary(
    totalFailureCount: Option[Integer] = None,
    failures: Option[Iterable[zio.aws.robomaker.model.WorldFailure]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.FailureSummary = {
    import FailureSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.FailureSummary
      .builder()
      .optionallyWith(totalFailureCount.map(value => value: java.lang.Integer))(
        _.totalFailureCount
      )
      .optionallyWith(
        failures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failures)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.FailureSummary.ReadOnly =
    zio.aws.robomaker.model.FailureSummary.wrap(buildAwsValue())
}
object FailureSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.FailureSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.FailureSummary =
      zio.aws.robomaker.model.FailureSummary(
        totalFailureCount.map(value => value),
        failures.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def totalFailureCount: Option[Integer]
    def failures: Option[List[zio.aws.robomaker.model.WorldFailure.ReadOnly]]
    def getTotalFailureCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalFailureCount", totalFailureCount)
    def getFailures: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.WorldFailure.ReadOnly
    ]] = AwsError.unwrapOptionField("failures", failures)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.FailureSummary
  ) extends zio.aws.robomaker.model.FailureSummary.ReadOnly {
    override val totalFailureCount: Option[Integer] =
      scala.Option(impl.totalFailureCount()).map(value => value: Integer)
    override val failures
        : Option[List[zio.aws.robomaker.model.WorldFailure.ReadOnly]] = scala
      .Option(impl.failures())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.WorldFailure.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.FailureSummary
  ): zio.aws.robomaker.model.FailureSummary.ReadOnly = new Wrapper(impl)
}
