package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.robomaker.model.primitives.BoxedBoolean
import scala.jdk.CollectionConverters.*
final case class LoggingConfig(recordAllRosTopics: BoxedBoolean) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.LoggingConfig = {
    import LoggingConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.LoggingConfig
      .builder()
      .recordAllRosTopics(recordAllRosTopics: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.LoggingConfig.ReadOnly =
    zio.aws.robomaker.model.LoggingConfig.wrap(buildAwsValue())
}
object LoggingConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.LoggingConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.LoggingConfig =
      zio.aws.robomaker.model.LoggingConfig(recordAllRosTopics)
    def recordAllRosTopics: BoxedBoolean
    def getRecordAllRosTopics: ZIO[Any, Nothing, BoxedBoolean] =
      ZIO.succeed(recordAllRosTopics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.LoggingConfig
  ) extends zio.aws.robomaker.model.LoggingConfig.ReadOnly {
    override val recordAllRosTopics: BoxedBoolean =
      impl.recordAllRosTopics(): BoxedBoolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.LoggingConfig
  ): zio.aws.robomaker.model.LoggingConfig.ReadOnly = new Wrapper(impl)
}
