package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RobotSoftwareSuite(
    name: Option[zio.aws.robomaker.model.RobotSoftwareSuiteType] = None,
    version: Option[zio.aws.robomaker.model.RobotSoftwareSuiteVersionType] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuite = {
    import RobotSoftwareSuite.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuite
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(version.map(value => value.unwrap))(_.version)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.RobotSoftwareSuite.ReadOnly =
    zio.aws.robomaker.model.RobotSoftwareSuite.wrap(buildAwsValue())
}
object RobotSoftwareSuite {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuite
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.RobotSoftwareSuite =
      zio.aws.robomaker.model.RobotSoftwareSuite(
        name.map(value => value),
        version.map(value => value)
      )
    def name: Option[zio.aws.robomaker.model.RobotSoftwareSuiteType]
    def version: Option[zio.aws.robomaker.model.RobotSoftwareSuiteVersionType]
    def getName
        : ZIO[Any, AwsError, zio.aws.robomaker.model.RobotSoftwareSuiteType] =
      AwsError.unwrapOptionField("name", name)
    def getVersion: ZIO[
      Any,
      AwsError,
      zio.aws.robomaker.model.RobotSoftwareSuiteVersionType
    ] = AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuite
  ) extends zio.aws.robomaker.model.RobotSoftwareSuite.ReadOnly {
    override val name: Option[zio.aws.robomaker.model.RobotSoftwareSuiteType] =
      scala
        .Option(impl.name())
        .map(value =>
          zio.aws.robomaker.model.RobotSoftwareSuiteType.wrap(value)
        )
    override val version
        : Option[zio.aws.robomaker.model.RobotSoftwareSuiteVersionType] = scala
      .Option(impl.version())
      .map(value =>
        zio.aws.robomaker.model.RobotSoftwareSuiteVersionType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuite
  ): zio.aws.robomaker.model.RobotSoftwareSuite.ReadOnly = new Wrapper(impl)
}
