package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.robomaker.model.primitives.{
  LastUpdatedAt,
  CreatedAt,
  TemplateName,
  Arn
}
import scala.jdk.CollectionConverters.*
final case class UpdateWorldTemplateResponse(
    arn: Option[Arn] = None,
    name: Option[TemplateName] = None,
    createdAt: Option[CreatedAt] = None,
    lastUpdatedAt: Option[LastUpdatedAt] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.UpdateWorldTemplateResponse = {
    import UpdateWorldTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.UpdateWorldTemplateResponse
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        name.map(value => TemplateName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => LastUpdatedAt.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.UpdateWorldTemplateResponse.ReadOnly =
    zio.aws.robomaker.model.UpdateWorldTemplateResponse.wrap(buildAwsValue())
}
object UpdateWorldTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.UpdateWorldTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.UpdateWorldTemplateResponse =
      zio.aws.robomaker.model.UpdateWorldTemplateResponse(
        arn.map(value => value),
        name.map(value => value),
        createdAt.map(value => value),
        lastUpdatedAt.map(value => value)
      )
    def arn: Option[Arn]
    def name: Option[TemplateName]
    def createdAt: Option[CreatedAt]
    def lastUpdatedAt: Option[LastUpdatedAt]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, TemplateName] =
      AwsError.unwrapOptionField("name", name)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, LastUpdatedAt] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.UpdateWorldTemplateResponse
  ) extends zio.aws.robomaker.model.UpdateWorldTemplateResponse.ReadOnly {
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val name: Option[TemplateName] = scala
      .Option(impl.name())
      .map(value => zio.aws.robomaker.model.primitives.TemplateName(value))
    override val createdAt: Option[CreatedAt] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.robomaker.model.primitives.CreatedAt(value))
    override val lastUpdatedAt: Option[LastUpdatedAt] = scala
      .Option(impl.lastUpdatedAt())
      .map(value => zio.aws.robomaker.model.primitives.LastUpdatedAt(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.UpdateWorldTemplateResponse
  ): zio.aws.robomaker.model.UpdateWorldTemplateResponse.ReadOnly = new Wrapper(
    impl
  )
}
