package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.{GenericString, NonEmptyString}
import scala.jdk.CollectionConverters.*
final case class VPCConfigResponse(
    subnets: Option[Iterable[NonEmptyString]] = None,
    securityGroups: Option[Iterable[NonEmptyString]] = None,
    vpcId: Option[GenericString] = None,
    assignPublicIp: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.VPCConfigResponse = {
    import VPCConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.VPCConfigResponse
      .builder()
      .optionallyWith(
        subnets.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnets)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(assignPublicIp.map(value => value: java.lang.Boolean))(
        _.assignPublicIp
      )
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.VPCConfigResponse.ReadOnly =
    zio.aws.robomaker.model.VPCConfigResponse.wrap(buildAwsValue())
}
object VPCConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.VPCConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.VPCConfigResponse =
      zio.aws.robomaker.model.VPCConfigResponse(
        subnets.map(value => value),
        securityGroups.map(value => value),
        vpcId.map(value => value),
        assignPublicIp.map(value => value)
      )
    def subnets: Option[List[NonEmptyString]]
    def securityGroups: Option[List[NonEmptyString]]
    def vpcId: Option[GenericString]
    def assignPublicIp: Option[Boolean]
    def getSubnets: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("subnets", subnets)
    def getSecurityGroups: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getVpcId: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getAssignPublicIp: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("assignPublicIp", assignPublicIp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.VPCConfigResponse
  ) extends zio.aws.robomaker.model.VPCConfigResponse.ReadOnly {
    override val subnets: Option[List[NonEmptyString]] = scala
      .Option(impl.subnets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val securityGroups: Option[List[NonEmptyString]] = scala
      .Option(impl.securityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val vpcId: Option[GenericString] =
      scala.Option(impl.vpcId()).map(value => value: GenericString)
    override val assignPublicIp: Option[Boolean] =
      scala.Option(impl.assignPublicIp()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.VPCConfigResponse
  ): zio.aws.robomaker.model.VPCConfigResponse.ReadOnly = new Wrapper(impl)
}
