package zio.aws.robomaker.model
import scala.jdk.CollectionConverters.*
sealed trait Architecture {
  def unwrap: software.amazon.awssdk.services.robomaker.model.Architecture
}
object Architecture {
  def wrap(
      value: software.amazon.awssdk.services.robomaker.model.Architecture
  ): zio.aws.robomaker.model.Architecture = value match {
    case software.amazon.awssdk.services.robomaker.model.Architecture.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.robomaker.model.Architecture.X86_64 =>
      val r = X86_64
      r
    case software.amazon.awssdk.services.robomaker.model.Architecture.ARM64 =>
      val r = ARM64
      r
    case software.amazon.awssdk.services.robomaker.model.Architecture.ARMHF =>
      val r = ARMHF
      r
  }
  case object unknownToSdkVersion extends zio.aws.robomaker.model.Architecture {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.Architecture =
      software.amazon.awssdk.services.robomaker.model.Architecture.UNKNOWN_TO_SDK_VERSION
  }
  case object X86_64 extends zio.aws.robomaker.model.Architecture {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.Architecture =
      software.amazon.awssdk.services.robomaker.model.Architecture.X86_64
  }
  case object ARM64 extends zio.aws.robomaker.model.Architecture {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.Architecture =
      software.amazon.awssdk.services.robomaker.model.Architecture.ARM64
  }
  case object ARMHF extends zio.aws.robomaker.model.Architecture {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.Architecture =
      software.amazon.awssdk.services.robomaker.model.Architecture.ARMHF
  }
}
