package zio.aws.robomaker.model
import zio.aws.robomaker.model.primitives.{
  IamRole,
  CreatedAt,
  ClientRequestToken,
  TagValue,
  Arn,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class CreateWorldExportJobResponse(
    arn: Optional[Arn] = Optional.Absent,
    status: Optional[zio.aws.robomaker.model.WorldExportJobStatus] =
      Optional.Absent,
    createdAt: Optional[CreatedAt] = Optional.Absent,
    failureCode: Optional[zio.aws.robomaker.model.WorldExportJobErrorCode] =
      Optional.Absent,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    outputLocation: Optional[zio.aws.robomaker.model.OutputLocation] =
      Optional.Absent,
    iamRole: Optional[IamRole] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.CreateWorldExportJobResponse = {
    import CreateWorldExportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.CreateWorldExportJobResponse
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(failureCode.map(value => value.unwrap))(_.failureCode)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(outputLocation.map(value => value.buildAwsValue()))(
        _.outputLocation
      )
      .optionallyWith(
        iamRole.map(value => IamRole.unwrap(value): java.lang.String)
      )(_.iamRole)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.CreateWorldExportJobResponse.ReadOnly =
    zio.aws.robomaker.model.CreateWorldExportJobResponse.wrap(buildAwsValue())
}
object CreateWorldExportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.CreateWorldExportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.CreateWorldExportJobResponse =
      zio.aws.robomaker.model.CreateWorldExportJobResponse(
        arn.map(value => value),
        status.map(value => value),
        createdAt.map(value => value),
        failureCode.map(value => value),
        clientRequestToken.map(value => value),
        outputLocation.map(value => value.asEditable),
        iamRole.map(value => value),
        tags.map(value => value)
      )
    def arn: Optional[Arn]
    def status: Optional[zio.aws.robomaker.model.WorldExportJobStatus]
    def createdAt: Optional[CreatedAt]
    def failureCode: Optional[zio.aws.robomaker.model.WorldExportJobErrorCode]
    def clientRequestToken: Optional[ClientRequestToken]
    def outputLocation
        : Optional[zio.aws.robomaker.model.OutputLocation.ReadOnly]
    def iamRole: Optional[IamRole]
    def tags: Optional[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.robomaker.model.WorldExportJobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getFailureCode
        : ZIO[Any, AwsError, zio.aws.robomaker.model.WorldExportJobErrorCode] =
      AwsError.unwrapOptionField("failureCode", failureCode)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getOutputLocation
        : ZIO[Any, AwsError, zio.aws.robomaker.model.OutputLocation.ReadOnly] =
      AwsError.unwrapOptionField("outputLocation", outputLocation)
    def getIamRole: ZIO[Any, AwsError, IamRole] =
      AwsError.unwrapOptionField("iamRole", iamRole)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.CreateWorldExportJobResponse
  ) extends zio.aws.robomaker.model.CreateWorldExportJobResponse.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val status
        : Optional[zio.aws.robomaker.model.WorldExportJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.robomaker.model.WorldExportJobStatus.wrap(value))
    override val createdAt: Optional[CreatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.robomaker.model.primitives.CreatedAt(value))
    override val failureCode
        : Optional[zio.aws.robomaker.model.WorldExportJobErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureCode())
        .map(value =>
          zio.aws.robomaker.model.WorldExportJobErrorCode.wrap(value)
        )
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.robomaker.model.primitives.ClientRequestToken(value)
        )
    override val outputLocation
        : Optional[zio.aws.robomaker.model.OutputLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputLocation())
        .map(value => zio.aws.robomaker.model.OutputLocation.wrap(value))
    override val iamRole: Optional[IamRole] = zio.aws.core.internal
      .optionalFromNullable(impl.iamRole())
      .map(value => zio.aws.robomaker.model.primitives.IamRole(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.robomaker.model.primitives
              .TagKey(key) -> zio.aws.robomaker.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.CreateWorldExportJobResponse
  ): zio.aws.robomaker.model.CreateWorldExportJobResponse.ReadOnly =
    new Wrapper(impl)
}
