package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.robomaker.model.primitives.{
  TagValue,
  TagKey,
  Arn,
  ClientRequestToken
}
import scala.jdk.CollectionConverters.*
final case class CreateWorldGenerationJobRequest(
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    template: Arn,
    worldCount: zio.aws.robomaker.model.WorldCount,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    worldTags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.CreateWorldGenerationJobRequest = {
    import CreateWorldGenerationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.CreateWorldGenerationJobRequest
      .builder()
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .template(Arn.unwrap(template): java.lang.String)
      .worldCount(worldCount.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        worldTags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.worldTags)
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.CreateWorldGenerationJobRequest.ReadOnly =
    zio.aws.robomaker.model.CreateWorldGenerationJobRequest
      .wrap(buildAwsValue())
}
object CreateWorldGenerationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.CreateWorldGenerationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.CreateWorldGenerationJobRequest =
      zio.aws.robomaker.model.CreateWorldGenerationJobRequest(
        clientRequestToken.map(value => value),
        template,
        worldCount.asEditable,
        tags.map(value => value),
        worldTags.map(value => value)
      )
    def clientRequestToken: Optional[ClientRequestToken]
    def template: Arn
    def worldCount: zio.aws.robomaker.model.WorldCount.ReadOnly
    def tags: Optional[Map[TagKey, TagValue]]
    def worldTags: Optional[Map[TagKey, TagValue]]
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getTemplate: ZIO[Any, Nothing, Arn] = ZIO.succeed(template)
    def getWorldCount
        : ZIO[Any, Nothing, zio.aws.robomaker.model.WorldCount.ReadOnly] =
      ZIO.succeed(worldCount)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getWorldTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("worldTags", worldTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.CreateWorldGenerationJobRequest
  ) extends zio.aws.robomaker.model.CreateWorldGenerationJobRequest.ReadOnly {
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.robomaker.model.primitives.ClientRequestToken(value)
        )
    override val template: Arn =
      zio.aws.robomaker.model.primitives.Arn(impl.template())
    override val worldCount: zio.aws.robomaker.model.WorldCount.ReadOnly =
      zio.aws.robomaker.model.WorldCount.wrap(impl.worldCount())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.robomaker.model.primitives
              .TagKey(key) -> zio.aws.robomaker.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val worldTags: Optional[Map[TagKey, TagValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.worldTags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.robomaker.model.primitives.TagKey(
                key
              ) -> zio.aws.robomaker.model.primitives.TagValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.CreateWorldGenerationJobRequest
  ): zio.aws.robomaker.model.CreateWorldGenerationJobRequest.ReadOnly =
    new Wrapper(impl)
}
